package com.ejianc.business.jlprogress.tech.vo;

import com.ejianc.foundation.share.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 工程技术-工程产业战略技术合作一览表
 *
 * @author generator
 *
 */
public class TechCooperationVOList extends BaseVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编码
    private Long orgId; // 组织ID(区域)
    private String orgCode; // 组织code(区域)
    private String orgName; // 组织名称(区域)
    private Long unitId; // 单位名称id(客户)
    private String unitName; // 单位名称name
    private Integer billState; // 单据状态（审批必须字段）

    private Long cooperationId; // 主表主键
    private String person; // 人员
    private String job; // 职务
    private String phone; // 联系方式
    private String responseName; // 负责人
    private Long responseId; //负责人id
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 签订日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date cutDate; // 截止日期
    private String projectName; // 项目名称
    private List<ITreeNodeB> children;


    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getResponseId() {
        return responseId;
    }
    @ReferDeserialTransfer
    public void setResponseId(Long responseId) {
        this.responseId = responseId;
    }

    public String getPerson() {
        return person;
    }

    public void setPerson(String person) {
        this.person = person;
    }

    public String getJob() {
        return job;
    }

    public void setJob(String job) {
        this.job = job;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getResponseName() {
        return responseName;
    }

    public void setResponseName(String responseName) {
        this.responseName = responseName;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public Date getCutDate() {
        return cutDate;
    }

    public void setCutDate(Date cutDate) {
        this.cutDate = cutDate;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    //这是设置 主表
    @Override
    public Long getNodeID() {
        //主显示   主表的id
        return getId();
    }

    //这是设置 附表
    @Override
    public Long getParentID() {
        //副显示  detail 表中 vo表的主键id
        return getCooperationId();
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    public Long getCooperationId() {
        return cooperationId;
    }

    public void setCooperationId(Long cooperationId) {
        this.cooperationId = cooperationId;
    }

    public void setChildren(List<ITreeNodeB> children) {
        this.children = children;
    }

    private List<TechCooperationDetailsVO> techCooperationDetailsList = new ArrayList<>(); // 工程产业战略技术合作一览表-子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode = "support-customer")
    public Long getUnitId() {
        return unitId;
    }
    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<TechCooperationDetailsVO> getTechCooperationDetailsList() {
        return techCooperationDetailsList;
    }

    public void setTechCooperationDetailsList(List<TechCooperationDetailsVO> techCooperationDetailsList) {
        this.techCooperationDetailsList = techCooperationDetailsList;
    }
}
