package com.ejianc.business.jlprogress.factory.controller;

import java.io.Serializable;

import cn.hutool.core.util.NumberUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlprogress.factory.vo.FactProgressDetailVO;
import com.ejianc.business.jlprogress.factory.vo.FactShareDetailVO;
import com.ejianc.business.jlprogress.progress.utils.DateUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlprogress.factory.bean.FactShareEntity;
import com.ejianc.business.jlprogress.factory.service.IFactShareService;
import com.ejianc.business.jlprogress.factory.vo.FactShareVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 制造厂-内部协作进度表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("factShare")
public class FactShareController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "FACT_SHARE_CODE";//此处需要根据实际修改

    @Autowired
    private IFactShareService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IDefdocApi defdocApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FactShareVO> saveOrUpdate(@RequestBody FactShareVO saveOrUpdateVO) {
        //一个月一个生产厂只能做一条数据
        QueryWrapper curQuery = new QueryWrapper();
        curQuery.eq("DATE_FORMAT(sign_month, '%Y-%m' )", new SimpleDateFormat("yyyy-MM").format(saveOrUpdateVO.getSignMonth()));
        curQuery.eq("factory_category",saveOrUpdateVO.getFactoryCategory());
        if(saveOrUpdateVO.getId() != null){
            curQuery.ne("id",saveOrUpdateVO.getId());
        }
        int curCount = service.count(curQuery);
        if (curCount > 0) throw new BusinessException("一个月一个生产厂只能做一条数据！");

        FactShareEntity entity = BeanMapper.map(saveOrUpdateVO, FactShareEntity.class);
        entity.setOrgId(InvocationInfoProxy.getOrgId());
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	FactShareVO vo = BeanMapper.map(entity, FactShareVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FactShareVO> queryDetail(Long id) {
    	FactShareEntity entity = service.selectById(id);
    	FactShareVO vo = BeanMapper.map(entity, FactShareVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FactShareVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (FactShareVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(FactShareVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FactShareVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        /*UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            *//** 要求主表有orgId字段，保存单据所属组织 *//*
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            *//** 要求主表有projectDepartmentId字段，保存单据所属项目部 *//*
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }*/
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<FactShareEntity> page = service.queryPage(param,false);
        IPage<FactShareVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), FactShareVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<FactShareEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("FactShare-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refFactShareData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<FactShareVO>> refFactShareData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<FactShareEntity> page = service.queryPage(param,false);
        IPage<FactShareVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FactShareVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "fact-share-import.xlsx", "导入模板");
    }

    @PostMapping(value = "/excelImport")
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;

        List<FactShareDetailVO> successList = new ArrayList<>();
        List<FactShareDetailVO> processList = new ArrayList<>();
        List<FactShareDetailVO> errorList = new ArrayList<>();

        //状态
        CommonResponse<List<DefdocDetailVO>> defDocByDefCodeStatus = defdocApi.getDefDocByDefCode("shareStatus");
        if (!defDocByDefCodeStatus.isSuccess()) {
            throw new BusinessException("获取档案信息失败!");
        }
        List<DefdocDetailVO> defDocByDefCodeDataStataus = defDocByDefCodeStatus.getData();
        Map<String, DefdocDetailVO> defdocDetailVOStatusMap = defDocByDefCodeDataStataus.stream().collect(Collectors.toMap(DefdocDetailVO::getName, Function.identity(), (key1, key2) -> key2));

        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }

        List<List<String>> result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
//            if(result.size() > 10000) {
//                return CommonResponse.error("导入数据超过10000条，请分批上传！");
//            }
            Map<String, FactShareDetailVO> codeMapCache = new HashMap<>();
            FactShareDetailVO importVo = null;
            for (int i = 1; i < result.size(); i++) {
                List<String> datas = result.get(i);
                importVo = new FactShareDetailVO();
                importVo.setId(IdWorker.getId());

                importVo.setPlanCode(datas.get(1));
                importVo.setCustomerName(datas.get(2));
                importVo.setProductName(datas.get(3));
                importVo.setSpec(datas.get(4));//规格
                if (StringUtils.isNotBlank(datas.get(5))) {
                    if (!TextUtils.isEmpty(datas.get(5)) && !NumberUtil.isNumber(datas.get(5))) {
                        importVo.setErrorMsg("报单数量格式不正确！");
                        errorList.add(importVo);
                        continue;
                    } else {
                        importVo.setSignNum(StringUtils.isNotBlank(datas.get(5)) ? new BigDecimal(datas.get(5)) : null);
                    }
                }
                if (StringUtils.isNotBlank(datas.get(0))) {
                    if (defdocDetailVOStatusMap.containsKey(datas.get(0))) {
                        DefdocDetailVO defdocDetailVO = defdocDetailVOStatusMap.get(datas.get(0));
                        importVo.setStateId(defdocDetailVO.getId());
                        importVo.setStateName(defdocDetailVO.getName());
                    } else {
                        importVo.setErrorMsg("状态不在自定义档案库！");
                        errorList.add(importVo);
                        continue;
                    }
                }

                if (StringUtils.isNotBlank(datas.get(6))) {
                    if (DateUtil.grepDate(datas.get(6))) {
                        importVo.setSignDate(DateUtil.Date(datas.get(6)));
                    } else {
                        importVo.setErrorMsg("报单日期格式不正确！");
                        errorList.add(importVo);
                        continue;
                    }
                }

                if (StringUtils.isNotBlank(datas.get(7))) {
                    if (DateUtil.grepDate(datas.get(7))) {
                        importVo.setGiveDate(DateUtil.Date(datas.get(7)));
                    } else {
                        importVo.setErrorMsg("交付日期格式不正确！");
                        errorList.add(importVo);
                        continue;
                    }
                }

                importVo.setSignFactory(datas.get(8));
                if (StringUtils.isNotBlank(datas.get(9))) {
                    if (DateUtil.grepDate(datas.get(9))) {
                        importVo.setTakeDate(DateUtil.Date(datas.get(9)));
                    } else {
                        importVo.setErrorMsg("接单日期格式不正确！");
                        errorList.add(importVo);
                        continue;
                    }
                }
                if (StringUtils.isNotBlank(datas.get(10))) {
                    if (DateUtil.grepDate(datas.get(10))) {
                        importVo.setActGiveDate(DateUtil.Date(datas.get(10)));
                    } else {
                        importVo.setErrorMsg("实际交付日期格式不正确！");
                        errorList.add(importVo);
                        continue;
                    }
                }
                if (StringUtils.isNotBlank(datas.get(11))) {
                    if (!TextUtils.isEmpty(datas.get(11)) && !NumberUtil.isNumber(datas.get(11))) {
                        importVo.setErrorMsg("实际交付数量格式不正确！");
                        errorList.add(importVo);
                        continue;
                    } else {
                        importVo.setActGiveNum(StringUtils.isNotBlank(datas.get(11)) ? new BigDecimal(datas.get(11)) : null);
                    }
                }
                importVo.setMemo(datas.get(12));
                successList.add(importVo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success(json);
    }
}
