package com.ejianc.business.jlprogress.order.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.ejianc.business.jlprogress.order.bean.OutStoreEntity;
import com.ejianc.business.jlprogress.order.bean.PriceDetailEntity;
import com.ejianc.business.jlprogress.order.bean.StoreEntity;
import com.ejianc.business.jlprogress.order.service.IPriceDetailService;
import com.ejianc.business.jlprogress.order.vo.PriceDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.server.PathParam;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlprogress.order.bean.PriceEntity;
import com.ejianc.business.jlprogress.order.service.IPriceService;
import com.ejianc.business.jlprogress.order.vo.PriceVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 订单及运单-材料价格-主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("price")
public class PriceController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IShareMaterialApi iShareMaterialApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PRICE_CODE";//此处需要根据实际修改

    @Autowired
    private IPriceService service;

    @Autowired
    private IPriceDetailService priceDetailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PriceVO> saveOrUpdate(@RequestBody PriceVO saveOrUpdateVO) {
        PriceEntity entity = BeanMapper.map(saveOrUpdateVO, PriceEntity.class);
        LambdaQueryWrapper<PriceEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(PriceEntity::getBillCode,saveOrUpdateVO.getBillCode());
        lambdaQueryWrapper.eq(PriceEntity::getDr,0);
        //修改的情况  去除本身
        if (entity.getId()!=null){
            lambdaQueryWrapper.ne(PriceEntity::getId,saveOrUpdateVO.getId());
        }
        List<PriceEntity> list = service.list(lambdaQueryWrapper);
        if (CollectionUtils.isNotEmpty(list)){
            throw new BusinessException("单据编码已存在！");
        }

        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if (entity.getId() == null || entity.getId() == 0) {
            LambdaQueryWrapper<PriceEntity> lambdaQueryWrapper1 = new LambdaQueryWrapper<>();
            lambdaQueryWrapper1.in(PriceEntity::getOrgId, entity.getOrgId());
            lambdaQueryWrapper1.in(PriceEntity::getMonth, entity.getMonth());
            if (service.getOne(lambdaQueryWrapper1) == null) {
                service.saveOrUpdate(entity, false);
                PriceVO vo = BeanMapper.map(entity, PriceVO.class);
                return CommonResponse.success("保存或修改单据成功！", vo);
            } else {
                return CommonResponse.error("同一个部门，同一个月份只允许有一个价格表！");
            }

        } else {
            service.saveOrUpdate(entity, false);
            PriceVO vo = BeanMapper.map(entity, PriceVO.class);
            return CommonResponse.success("保存或修改单据成功！", vo);
        }
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PriceVO> queryDetail(Long id) {
    	PriceEntity entity = service.selectById(id);
    	PriceVO vo = BeanMapper.map(entity, PriceVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PriceVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PriceVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PriceVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询价格表是否存在
     * @param
     * @Return
     */
    @RequestMapping(value = "/queryExist", method = RequestMethod.GET)
    @ResponseBody
    public boolean queryExist(@PathParam("deptId") Long deptId, @PathParam("month") String month) {
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        HashMap<String, Parameter> map = new HashMap<>();
        map.put("orgId", new Parameter(QueryParam.EQ, deptId));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM");
        try {
            Date parse = simpleDateFormat.parse(month);
            map.put("month", new Parameter(QueryParam.EQ, parse));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        param.setParams(map);
        List<PriceEntity> priceEntities = service.queryList(param);
        return !priceEntities.isEmpty();
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PriceVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        if(ObjectUtils.isNotEmpty(param.getParams().get("month"))) {
            param.getParams().put("month", new Parameter(QueryParam.IN, param.getParams().get("month").getValue() + "-01"));
        }
        IPage<PriceEntity> page = service.queryPage(param, false);
        IPage<PriceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PriceVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);

    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        if(ObjectUtils.isNotEmpty(param.getParams().get("month"))) {
            param.getParams().put("month", new Parameter(QueryParam.IN, param.getParams().get("month").getValue() + "-01"));
        }
        List<PriceEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<PriceVO> resDatas = BeanMapper.mapList(list, PriceVO.class);
        for (PriceVO resData : resDatas) {
            switch (resData.getBillState()) {
                case 0:
                    resData.setBillStateName("自由态");
                    break;
                case 1:
                    resData.setBillStateName("已提交");
                    break;
                case 2:
                case 5:
                    resData.setBillStateName("审批中");
                    break;
                case 3:
                    resData.setBillStateName("审批通过");
                    break;
                case 4:
                    resData.setBillStateName("审批驳回");
                    break;
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resDatas);
        ExcelExport.getInstance().export("Price-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refPriceData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PriceVO>> refPriceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PriceEntity> page = service.queryPage(param,false);
        IPage<PriceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PriceVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadInfo")
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "PriceDetail-import.xlsx", "材料明细表明细模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<PriceDetailVO> successList = new ArrayList<>();
        List<PriceDetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //获取物资档案数据
                List<String> materialCodeList = new ArrayList<>();
                List<String> storeNameList = new ArrayList<>();
                Map<String, MaterialVO> map = new HashMap<>();
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    materialCodeList.add(datas.get(1));//取材料编码  用来校验
                    storeNameList.add(datas.get(0));
                }
                List<String> listWithoutDuplicates = materialCodeList.stream().distinct().collect(Collectors.toList());
                List<List<String>> resultWithoutDuplicates = result.stream().distinct().collect(Collectors.toList());
                List<String> queryMaterialCodeList = new ArrayList<>();
                List<MaterialVO> materialVOList = new ArrayList<>();
                for (String listWithoutDuplicate : listWithoutDuplicates) {
                    queryMaterialCodeList.add(listWithoutDuplicate);
                    if (queryMaterialCodeList.size() == 300){
                        CommonResponse<List<MaterialVO>> materialRes =  iShareMaterialApi.queryMaterialListByCodes(queryMaterialCodeList);
                        if(!materialRes.isSuccess()){
                            return CommonResponse.error(materialRes.getMsg());
                        }else {
                            materialVOList.addAll(materialRes.getData());
                        }
                        queryMaterialCodeList.clear();
                    }
                }
                if (queryMaterialCodeList.size() > 0){
                    CommonResponse<List<MaterialVO>> materialRes =  iShareMaterialApi.queryMaterialListByCodes(queryMaterialCodeList);
                    if(!materialRes.isSuccess()){
                        return CommonResponse.error(materialRes.getMsg());
                    }else {
                        materialVOList.addAll(materialRes.getData());
                    }
                }
                List<StoreEntity> storeEntities = service.queryStoreByStoreNames(storeNameList);
                map = materialVOList.stream().collect(Collectors.toMap(p -> p.getCode(), Function.identity(), (p1, p2) -> p1));
                Map<String, StoreEntity> map1 = storeEntities.stream().collect(Collectors.toMap(p -> p.getStoreName(), Function.identity()));


                for (int i = 1; i < resultWithoutDuplicates.size(); i++) {
                    List<String> datas = resultWithoutDuplicates.get(i);
                    PriceDetailVO detailVO = new PriceDetailVO();
                    detailVO.setId(com.ejianc.support.idworker.util.IdWorker.getId());
                    String materialCode = datas.get(1);
                    detailVO.setMaterialCode(materialCode);
                    String storeName = datas.get(0);
                    if (ObjectUtils.isEmpty(map1)){
                        try {
                            throw new Exception("没有此仓库！");
                        } catch (Exception e) {
                            detailVO.setErrorMsg("没有此仓库！");
                            errorList.add(detailVO);
                            continue;}
                    }
                    //材料code  材料Id赋值
                    try {

                        if (ObjectUtils.isEmpty(map.get(materialCode))){
                            throw new Exception("没有此材料！");
                        }

                        detailVO.setMaterialId(map.get(materialCode).getId());
                        detailVO.setMaterialName(map.get(materialCode).getName());
                        detailVO.setSpec(map.get(materialCode).getSpec());
                        detailVO.setModel(map.get(materialCode).getModel());
                        detailVO.setUnit(map.get(materialCode).getUnitName());
                        detailVO.setMaterialTypeId(map.get(materialCode).getCategoryId());
                        detailVO.setMaterialTypeCode(map.get(materialCode).getCategoryCode());
                        detailVO.setMaterialTypeName(map.get(materialCode).getCategoryName());
                        detailVO.setStoreId(map1.get(storeName).getId());
                        detailVO.setStoreCode(map1.get(storeName).getStoreCode());
                        detailVO.setStoreName(map1.get(storeName).getStoreCode());
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("没有此材料！");
                        errorList.add(detailVO);
                        continue;
                    }
                    //单价赋值
                    try {
                        String materialPrice = datas.get(6);
                        BigDecimal multiplier = new BigDecimal("1.13");
                        detailVO.setMaterialPrice(new BigDecimal(materialPrice).multiply(multiplier));
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("出库单价不能为空或单价格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    successList.add(detailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}
