package com.ejianc.business.jlprogress.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlprogress.order.bean.CheckDetailEntity;
import com.ejianc.business.jlprogress.order.bean.CheckEntity;
import com.ejianc.business.jlprogress.order.bean.DeliveryDetailEntity;
import com.ejianc.business.jlprogress.order.bean.DeliveryEntity;
import com.ejianc.business.jlprogress.order.mapper.CheckMapper;
import com.ejianc.business.jlprogress.order.service.ICheckService;
import com.ejianc.business.jlprogress.order.service.IDeliveryDetailService;
import com.ejianc.business.jlprogress.order.service.IDeliveryService;
import com.ejianc.framework.core.util.ComputeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("check")
public class CheckBpmServiceImpl implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICheckService checkService;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    @Autowired
    private DeliveryServiceImpl deliveryService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批后回调
     *
     * @param billId       //单据id
     * @param state        //单据状态
     * @param billTypeCode //单据类型code
     * @param taskId       //该流程id
     * @param isEnd        //该节点是否结束
     * @return
     */
    @Override
    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {

        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("终审前回调执行：id={billId}");
        CheckEntity check = checkService.selectById(billId);
        DeliveryEntity delivery = deliveryService.selectById(check.getDeliveryId());

        Map<Long, DeliveryDetailEntity> deliveryDetailMap = delivery.getDeliveryDetailList().stream().collect(Collectors.toMap(DeliveryDetailEntity::getId, item -> item));
        for (CheckDetailEntity detail : check.getCheckDetailList()) {
            if (detail.getSourceType() != 3) {
                continue;
            }
            DeliveryDetailEntity deliveryDetailEntity = deliveryDetailMap.get(detail.getSourceDetailId());
            deliveryDetailEntity.setCheckNum(ComputeUtil.safeAdd(detail.getMaterialNum(),detail.getHistoryMaterialNum()));
            deliveryDetailMap.put(detail.getSourceDetailId(), deliveryDetailEntity);
        }
        delivery.setDeliveryDetailList(new ArrayList<>(deliveryDetailMap.values()));
        logger.info("发货通知单回写结果：{}",delivery);
        boolean checkFlag = true;
        for (DeliveryDetailEntity detail : delivery.getDeliveryDetailList()) {
            if (detail.getCheckNum().compareTo(detail.getNum()) < 0) {
                checkFlag = false;
            }
        }
        if (checkFlag) {
            delivery.setCheckStatus(2);
            delivery.setReceiptStatus(1);
        } else {
            delivery.setCheckStatus(1);
        }
        deliveryService.saveOrUpdate(delivery,false);
        logger.info("终审前回调执行：发货单回写验收数量成功 id={}", delivery.getId());
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
