package com.ejianc.business.jlprogress.order.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlcost.cost.api.ITargetApi;
import com.ejianc.business.jlcost.cost.enums.CostTypeEnum;
import com.ejianc.business.jlcost.cost.vo.OtherVO;
import com.ejianc.business.jlcost.cost.vo.QueryTargetDataVO;
import com.ejianc.business.jlcost.payout.vo.SjCostReportVO;
import com.ejianc.business.jlprogress.order.vo.CheckVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlprogress.order.mapper.CheckMapper;
import com.ejianc.business.jlprogress.order.bean.CheckEntity;
import com.ejianc.business.jlprogress.order.service.ICheckService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 订单及运单-交付验收单-主表
 * 
 * @author generator
 * 
 */
@Service("checkService")
public class CheckServiceImpl extends BaseServiceImpl<CheckMapper, CheckEntity> implements ICheckService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String YF_MNY_PARAM_CODE = "P-3h98630005";//【目标成本-运费】管控【实际运费】

    @Autowired
    private ITargetApi targetApi;

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private CheckMapper checkMapper;

    @Override
    public ParamsCheckVO checkParams(CheckVO vo) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
        paramsCheckVOS.addAll(this.checkParamsByMny(vo));//【目标成本-运费】管控【实际运费】

        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> checkParamsByMny(CheckVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();

        BigDecimal mny = vo.getTransportMny();//本次交付验收单运费
        BigDecimal targetMny;//目标成本运费
        BigDecimal totalMny = mny;//累计运费  默认赋值本次

        //1.查询目标成本 运费
        CommonResponse<List<QueryTargetDataVO>> targetData = targetApi.getTargetDataByProjectId(vo.getProjectId());
        if (!targetData.isSuccess()){
            throw new BusinessException("获取目标成本费用信息失败！");
        }

        //未编制目标成本或目标成本中没有运费时不管控
        List<QueryTargetDataVO> targetDataList = targetData.getData();
        if (CollectionUtils.isEmpty(targetDataList)){
            return paramsCheckVOS;
        }
        Map<Integer, BigDecimal> targetMap = targetDataList.stream().collect(Collectors.toMap(QueryTargetDataVO::getCostType, QueryTargetDataVO::getMny));
        if (!targetMap.containsKey(CostTypeEnum.运费.getCode())){
            return paramsCheckVOS;
        }
        targetMny = targetMap.get(CostTypeEnum.运费.getCode());

        //2.查询累计运费
        List<SjCostReportVO> queryDataList = checkMapper.getMnyByProjectId(vo.getProjectId());
        if (CollectionUtils.isNotEmpty(queryDataList)){
            for (SjCostReportVO reportVO : queryDataList) {
                if (!(null != vo.getId() && reportVO.getId().compareTo(vo.getId()) == 0)){
                    totalMny = ComputeUtil.safeAdd(totalMny, reportVO.getMny());
                }
            }
        }

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(YF_MNY_PARAM_CODE, vo.getOrgId());

        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("【目标成本-运费】管控【实际运费】："+ JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(targetMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("运费超额预警");
                        paramsCheckDsVO.setWarnName("项目运费超目标成本");
                        StringBuffer stringBuffer = new StringBuffer();
                        String totalMnyStr = totalMny.setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                        String targetMnyStr = targetMny.setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                        String text = "超出金额：" + totalMnyStr + "-" + targetMnyStr + "*" + roleValue + "%=" + ComputeUtil.safeSub(totalMny, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)+"元";
                        String redText = Jsoup.parse("<font color=\"red\">" + text + "</font>").body().html();
                        stringBuffer.append("累计运费金额：").append(totalMnyStr)
                                .append("元，目标成本运费金额：").append(targetMnyStr)
                                .append("元，管控比例：").append(roleValue).append("%，")
                                .append(redText);
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        }
        else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOS;
    }
    @Override
    public JSONObject getCheckDataByContractId(Long contractId) {
        JSONObject jsonObject = new JSONObject();
        LambdaQueryWrapper<CheckEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(CheckEntity::getContractId, contractId);
        queryWrapper.in(CheckEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<CheckEntity> list = list(queryWrapper);
        jsonObject.put("checkList", list);
        jsonObject.put("checkState", CollectionUtils.isNotEmpty(list) && list.size() > 0 ? "已验收" : "未验收");
        return jsonObject;
    }

    @Override
    public Map<Long, JSONObject> getCheckDataByContractIdList(List<Long> ids) {
        Map<Long, JSONObject> collectMap = new HashMap<>();
        LambdaQueryWrapper<CheckEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(CheckEntity::getContractId, ids);
        queryWrapper.in(CheckEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<CheckEntity> list = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list) && list.size() > 0){
            Map<Long, List<CheckEntity>> checkDataMap  = list.stream().collect(Collectors.groupingBy(CheckEntity::getContractId));
            for (Long contractId : checkDataMap.keySet()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("checkList", checkDataMap.get(contractId));
                jsonObject.put("checkState", CollectionUtils.isNotEmpty(checkDataMap.get(contractId)) && checkDataMap.get(contractId).size() > 0 ? "已验收" : "未验收");
                collectMap.put(contractId, jsonObject);
            }
        }
        return collectMap;
    }

}
