package com.ejianc.business.jlprogress.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlprogress.order.bean.CheckDetailEntity;
import com.ejianc.business.jlprogress.order.bean.CheckEntity;
import com.ejianc.business.jlprogress.order.bean.ProductOutEntity;
import com.ejianc.business.jlprogress.order.service.ICheckDetailService;
import com.ejianc.business.jlprogress.order.service.ICheckService;
import com.ejianc.business.jlprogress.order.service.IProductOutService;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Service("productOut") 
public class ProductOutBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IProductOutService productOutService;

	@Autowired
	private ICheckService checkService;

	@Autowired
	private ICheckDetailService checkDetailService;

	@Autowired
	private IProjectArchiveApi projectArchiveApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return bpmBackCheck(billId, state, billTypeCode);
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//回写项目信息-项目阶段
		ProductOutEntity entity = productOutService.getById(billId);

		LambdaQueryWrapper<ProductOutEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
		lambdaQueryWrapper.eq(ProductOutEntity::getProjectId, entity.getProjectId());
		lambdaQueryWrapper.in(ProductOutEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
		lambdaQueryWrapper.ne(ProductOutEntity::getId, billId);

		CommonResponse<String> projectArchiveRes = projectArchiveApi.updateArchiveProjectStatus(ArchiveProjectStatusEnum.供货阶段.getCode(), entity.getProjectId(), entity.getId(), productOutService.list(lambdaQueryWrapper).size() > 0 ? true : false, true);
		if (!projectArchiveRes.isSuccess()){
			throw new BusinessException("修改项目阶段失败，原因-" + projectArchiveRes.getMsg());
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		QueryWrapper<CheckDetailEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("source_detail_id",billId);
		List<CheckDetailEntity> checkDetailEntities = checkDetailService.list(queryWrapper);
		for (CheckDetailEntity checkDetail : checkDetailEntities) {
			if (checkDetail != null) {
				return CommonResponse.error("下游存在引用数据，无法删除");
			} else {
				checkDetail.setDr(1);
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return bpmBackCheck(billId, state, billTypeCode);
	}


	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		//回写项目信息-项目阶段
		ProductOutEntity entity = productOutService.getById(billId);

		LambdaQueryWrapper<ProductOutEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
		lambdaQueryWrapper.eq(ProductOutEntity::getProjectId, entity.getProjectId());
		lambdaQueryWrapper.in(ProductOutEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
		lambdaQueryWrapper.ne(ProductOutEntity::getId, billId);

		CommonResponse<String> projectArchiveRes = projectArchiveApi.updateArchiveProjectStatus(ArchiveProjectStatusEnum.供货阶段.getCode(), entity.getProjectId(), entity.getId(), productOutService.list(lambdaQueryWrapper).size() > 0 ? true : false, false);
		if (!projectArchiveRes.isSuccess()){
			throw new BusinessException("修改项目阶段失败，原因-" + projectArchiveRes.getMsg());
		}
		return CommonResponse.success();
	}

}
