package com.ejianc.business.jlprogress.progress.utils;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SeparatorUtil {

    private final static String SEPARATOR = "@@";

    public static List<String> substringPre(String str) {
        return substringPre(str, SEPARATOR);
    }

    public static List<String> substringPre(String str, String separator){
        if(StringUtils.isEmpty(str)){
            return new ArrayList<>();
        }
        List<String> strs = new ArrayList<>();
        int cont = StringUtils.countMatches(str, separator);
        String pre = str;
        strs.add(pre);
        for(int i = 0; i < cont; i++){
            pre = StringUtils.substringBeforeLast(pre, separator);
            strs.add(pre);
        }
        Collections.reverse(strs);
        return strs;
    }

    public static void main(String[] args) {
        String str = "1@@33@@34@@37@@38";
        System.out.println(JSONObject.toJSONString(substringPre(str)));
    }

}
