package com.ejianc.business.jlprogress.quality.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.jlprogress.quality.vo.SupplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlprogress.quality.mapper.SupplyMapper;
import com.ejianc.business.jlprogress.quality.bean.SupplyEntity;
import com.ejianc.business.jlprogress.quality.service.ISupplyService;

import java.util.List;

/**
 * 物资供货单
 * 
 * @author generator
 * 
 */
@Service("supplyService")
public class SupplyServiceImpl extends BaseServiceImpl<SupplyMapper, SupplyEntity> implements ISupplyService{
    private static final String BILL_CODE = "WZGH";//此处需要根据实际修改
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public SupplyVO saveOrUpdate(SupplyVO vo) {
        SupplyEntity entity = BeanMapper.map(vo, SupplyEntity.class);

        if(StringUtils.isNotBlank(entity.getBillCode())){
            checkCode(entity);
        }else{
            //判断编码是否存在 不存在生成
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),vo);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(null==entity.getReferenceFlag()){
            entity.setReferenceFlag(0);
        }
        super.saveOrUpdate(entity, false);
        SupplyVO supply =  BeanMapper.map(entity, SupplyVO.class);
        return supply;
    }

    public void checkCode(SupplyEntity entity) {
        QueryWrapper<SupplyEntity> queryWrapper = new QueryWrapper();
        queryWrapper.eq("bill_code", entity.getBillCode());
        queryWrapper.eq("dr", 0);
        if(entity.getId() != null ){
            queryWrapper.ne("id", entity.getId());
        }
        List<SupplyEntity> list = super.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("供货单编号重复，请重新输入！");

        }
    }
}
