package com.ejianc.business.jlprogress.tech.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.jlprogress.tech.vo.TechTestDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 工程技术-型式试验情况-主表
 * 
 * @author generator
 * 
 */
public class TechTestVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long reportId; // 填报人id
    private String reportName; // 填报人name
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date month; // 填报月份
    private Long projectId; // 项目ID
    private String projectCode; // 项目code
    private String projectName; // 项目名称
    private Long orgId; // 组织ID
    private String orgCode; // 组织code
    private String orgName; // 组织名称
    private Long parentOrgId; // 父级组织
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; // 父级组织名称
    private Integer billState; // 单据状态（审批必须字段）
    
    private List<TechTestDetailVO> techTestDetailList = new ArrayList<>(); // 工程技术-型式试验情况-子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getReportId() {
        return reportId;
    }
    @ReferDeserialTransfer
    public void setReportId(Long reportId) {
        this.reportId = reportId;
    }
    public String getReportName() {
        return reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }
    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
     public List<TechTestDetailVO> getTechTestDetailList() {
        return techTestDetailList;
     }

     public void setTechTestDetailList(List<TechTestDetailVO> techTestDetailList) {
        this.techTestDetailList = techTestDetailList;
     }
}
