package com.ejianc.business.jltest.orgtest.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.jltest.orgtest.vo.MeetingDetailVO;
import com.ejianc.business.jltest.orgtest.vo.MeetingEmployeeVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 安全生成会议
 * 
 * @author generator
 * 
 */
public class MeetingVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 安全生产会议发文字号
    private String meetingName; // 会议名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date meetingDate; // 会议时间
    private String meetingAddress; // 会议地点
    private String meetingPeople; // 记录人
    private Long safeteamaId; // 安全小组主键
    private String safeteamaName; // 安全小组发文名称
    private String safeteamaBillCode; // 安全小组成立发文字号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date safeteamaDate; // 安全小组发文日期
    private Long projectId; // 项目
    private String projectName; // 
    private String projectCode; // 项目code
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private String orgCode; // 组织code
    private String parentOrgName; // 
    private String parentOrgCode; // 父级组织编码
    private Long parentOrgId; // 父级组织
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private String memo; // 会议内容
    private Integer billState; // 单据状态（审批必须字段）
    private BigDecimal mny; // 薪资
    
    private List<MeetingDetailVO> meetingDetailList = new ArrayList<>(); // 参会人员1
    private List<MeetingEmployeeVO> meetingEmployeeList = new ArrayList<>(); // 参会人员2

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getMeetingName() {
        return meetingName;
    }

    public void setMeetingName(String meetingName) {
        this.meetingName = meetingName;
    }
    public Date getMeetingDate() {
        return meetingDate;
    }

    public void setMeetingDate(Date meetingDate) {
        this.meetingDate = meetingDate;
    }
    public String getMeetingAddress() {
        return meetingAddress;
    }

    public void setMeetingAddress(String meetingAddress) {
        this.meetingAddress = meetingAddress;
    }
    public String getMeetingPeople() {
        return meetingPeople;
    }

    public void setMeetingPeople(String meetingPeople) {
        this.meetingPeople = meetingPeople;
    }
    @ReferSerialTransfer(referCode="safeTeam-a")
    public Long getSafeteamaId() {
        return safeteamaId;
    }
    @ReferDeserialTransfer
    public void setSafeteamaId(Long safeteamaId) {
        this.safeteamaId = safeteamaId;
    }
    public String getSafeteamaName() {
        return safeteamaName;
    }

    public void setSafeteamaName(String safeteamaName) {
        this.safeteamaName = safeteamaName;
    }
    public String getSafeteamaBillCode() {
        return safeteamaBillCode;
    }

    public void setSafeteamaBillCode(String safeteamaBillCode) {
        this.safeteamaBillCode = safeteamaBillCode;
    }
    public Date getSafeteamaDate() {
        return safeteamaDate;
    }

    public void setSafeteamaDate(Date safeteamaDate) {
        this.safeteamaDate = safeteamaDate;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    
     public List<MeetingDetailVO> getMeetingDetailList() {
        return meetingDetailList;
     }

     public void setMeetingDetailList(List<MeetingDetailVO> meetingDetailList) {
        this.meetingDetailList = meetingDetailList;
     }
     public List<MeetingEmployeeVO> getMeetingEmployeeList() {
        return meetingEmployeeList;
     }

     public void setMeetingEmployeeList(List<MeetingEmployeeVO> meetingEmployeeList) {
        this.meetingEmployeeList = meetingEmployeeList;
     }
}
