package com.ejianc.business.jltest.orgtest.vo;


import com.ejianc.business.pro.income.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PlancListVO extends BaseVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;

    private String billCode; // 安措费使用计划发文字号
    private String planName; // 安措费使用计划发文名称
    private Integer urgencyDegree; // 紧急程度（1-一般，2-急，3-特急）
    private Integer securityClass; // 密级（1-公开，2-秘密，3-机密，4-绝密）
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planDate; // 安措费使用计划发文日期
    private BigDecimal planMny; // 拟投入金额
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private String projectCode; // 项目code
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private String orgCode; // 组织code
    private Long parentOrgId; // 父级组织
    private String parentOrgName; // 父级组织名称
    private String parentOrgCode; // 父级组织编码
    private Long safeteamcId; // 安全小组主键
    private String safeteamcName; // 安全小组发文名称
    private String safeteamcBillCode; // 安全小组成立发文字号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date safeteamcDate; // 安全小组发文日期
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long submitEmployeeId; // 提交人
    private String submitEmployeeName; // 提交人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private Long listerId; // 制表人
    private String listerName; // 制表人名称
    private String memo; // 安措费使用计发文说明
    private Integer billState; // 单据状态（审批必须字段）
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date submitDate; // 提交日期

    private Long planId; // 主表主键ID
    private String detailName; // 安全费用项目名称
    private BigDecimal detailMny; // 拟投入金额（万元）
    private BigDecimal detailMaxMny; // 最大拟投入金额
    private Long detailOrgId; // 组织Id
    private String detailOrgName; // 组织名称
    private Integer detailOrgType; // 组织类型

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date detailDate; // 使用时间
    private String detailMemo; // 安措费使用计发文说明

    private List<PlancDetailVO> plancDetailList = new ArrayList<>(); // 参会人员1


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getPlanName() {
        return planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }

    public Integer getUrgencyDegree() {
        return urgencyDegree;
    }

    public void setUrgencyDegree(Integer urgencyDegree) {
        this.urgencyDegree = urgencyDegree;
    }

    public Integer getSecurityClass() {
        return securityClass;
    }

    public void setSecurityClass(Integer securityClass) {
        this.securityClass = securityClass;
    }

    public Date getPlanDate() {
        return planDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }

    public BigDecimal getPlanMny() {
        return planMny;
    }

    public void setPlanMny(BigDecimal planMny) {
        this.planMny = planMny;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    @ReferSerialTransfer(referCode = "safeTeam-c")
    public Long getSafeteamcId() {
        return safeteamcId;
    }

    @ReferDeserialTransfer
    public void setSafeteamcId(Long safeteamcId) {
        this.safeteamcId = safeteamcId;
    }

    public String getSafeteamcName() {
        return safeteamcName;
    }

    public void setSafeteamcName(String safeteamcName) {
        this.safeteamcName = safeteamcName;
    }

    public String getSafeteamcBillCode() {
        return safeteamcBillCode;
    }

    public void setSafeteamcBillCode(String safeteamcBillCode) {
        this.safeteamcBillCode = safeteamcBillCode;
    }

    public Date getSafeteamcDate() {
        return safeteamcDate;
    }

    public void setSafeteamcDate(Date safeteamcDate) {
        this.safeteamcDate = safeteamcDate;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getSubmitEmployeeId() {
        return submitEmployeeId;
    }

    @ReferDeserialTransfer
    public void setSubmitEmployeeId(Long submitEmployeeId) {
        this.submitEmployeeId = submitEmployeeId;
    }

    public String getSubmitEmployeeName() {
        return submitEmployeeName;
    }

    public void setSubmitEmployeeName(String submitEmployeeName) {
        this.submitEmployeeName = submitEmployeeName;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Date getSubmitDate() {
        return submitDate;
    }

    public void setSubmitDate(Date submitDate) {
        this.submitDate = submitDate;
    }

    public List<PlancDetailVO> getPlancDetailList() {
        return plancDetailList;
    }

    public void setPlancDetailList(List<PlancDetailVO> plancDetailList) {
        this.plancDetailList = plancDetailList;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getListerId() {
        return listerId;
    }

    @ReferDeserialTransfer
    public void setListerId(Long listerId) {
        this.listerId = listerId;
    }

    public String getListerName() {
        return listerName;
    }

    public void setListerName(String listerName) {
        this.listerName = listerName;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public String getDetailName() {
        return detailName;
    }

    public void setDetailName(String detailName) {
        this.detailName = detailName;
    }

    public BigDecimal getDetailMny() {
        return detailMny;
    }

    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }

    public Date getDetailDate() {
        return detailDate;
    }

    public void setDetailDate(Date detailDate) {
        this.detailDate = detailDate;
    }

    public String getDetailMemo() {
        return detailMemo;
    }

    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }

    public BigDecimal getDetailMaxMny() {
        return detailMaxMny;
    }

    public void setDetailMaxMny(BigDecimal detailMaxMny) {
        this.detailMaxMny = detailMaxMny;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getDetailOrgId() {
        return detailOrgId;
    }

    @ReferDeserialTransfer
    public void setDetailOrgId(Long detailOrgId) {
        this.detailOrgId = detailOrgId;
    }

    public String getDetailOrgName() {
        return detailOrgName;
    }

    public void setDetailOrgName(String detailOrgName) {
        this.detailOrgName = detailOrgName;
    }

    public Integer getDetailOrgType() {
        return detailOrgType;
    }

    public void setDetailOrgType(Integer detailOrgType) {
        this.detailOrgType = detailOrgType;
    }

    private List<ITreeNodeB> children;

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return getPlanId();
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }
}
