package com.ejianc.business.jltest.margin.vo;

import java.util.ArrayList;
import java.util.Date;
import java.math.*;
import java.util.List;

import com.ejianc.business.jltest.orgtest.vo.DangercDetailVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 质管部风险金缴纳标准
 *
 * @author generator
 */
public class DirectStandardVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编码
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private String orgCode; // 组织code
    private BigDecimal amountLast; // 上一年度完成合同额
    private BigDecimal amountGoal; // 本年度完成合同额（指标）
    private BigDecimal valueLast; // 上一年度产值
    private BigDecimal valueGoal; // 本年度产值
    private Integer year; // 所属年度
    private BigDecimal marginPayable; // 风险金应缴纳金额
    private BigDecimal marginRatio; // 风险金申请缴纳比例
    private BigDecimal marginApply; // 风险金申请缴纳金额
    private Long employeeId; // 申请人
    private String employeeName; // 申请人名称
    private Long departmentId; // 申请部门
    private String departmentName; // 申请部门名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate; //申请日期
    private Integer changeState; //变更状态 1-未变更 2-已变更 3-变更中
    private String memo; // 申请事由
    private Integer billState; // 单据状态（审批必须字段）

    private List<DirectStandardDetailVO> detailList = new ArrayList<>(); // 参会人员1

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public BigDecimal getAmountLast() {
        return amountLast;
    }

    public void setAmountLast(BigDecimal amountLast) {
        this.amountLast = amountLast;
    }


    public BigDecimal getValueLast() {
        return valueLast;
    }

    public void setValueLast(BigDecimal valueLast) {
        this.valueLast = valueLast;
    }

    public BigDecimal getValueGoal() {
        return valueGoal;
    }

    public void setValueGoal(BigDecimal valueGoal) {
        this.valueGoal = valueGoal;
    }

    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public BigDecimal getMarginPayable() {
        return marginPayable;
    }

    public void setMarginPayable(BigDecimal marginPayable) {
        this.marginPayable = marginPayable;
    }

    public BigDecimal getMarginRatio() {
        return marginRatio;
    }

    public void setMarginRatio(BigDecimal marginRatio) {
        this.marginRatio = marginRatio;
    }

    public BigDecimal getMarginApply() {
        return marginApply;
    }

    public void setMarginApply(BigDecimal marginApply) {
        this.marginApply = marginApply;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }


    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }

    public List<DirectStandardDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<DirectStandardDetailVO> detailList) {
        this.detailList = detailList;
    }

    public BigDecimal getAmountGoal() {
        return amountGoal;
    }

    public void setAmountGoal(BigDecimal amountGoal) {
        this.amountGoal = amountGoal;
    }
}
