package com.ejianc.business.jltest.margin.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 直管部缴纳员工明细表
 *
 * @author generator
 */
public class DirectEmployeeDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long directEmployeeId; // 直管部人员表ID
    private Long directEmployeeCode; //直管部人员表编码
    private Long employeeId; // 人员id
    private String employeeName; // 人员名称
    private String roleName; //角色名称
    private String phone; // 手机号
    private BigDecimal wageMny; // 工资金额
    private BigDecimal marginMny; // 缴纳金额
    private BigDecimal marginRatio; // 缴纳占比
    private BigDecimal marginActual; // 实际缴纳金额
    private BigDecimal marginUnpaid; // 未缴纳金额
    private Integer byStages; // 是否分期（1-是 2-否）
    private BigDecimal arginUnpaidRatio; // 实际缴纳占比
    private String memo; // 备注


    public Long getDirectEmployeeId() {
        return directEmployeeId;
    }

    public void setDirectEmployeeId(Long directEmployeeId) {
        this.directEmployeeId = directEmployeeId;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public BigDecimal getWageMny() {
        return wageMny;
    }

    public void setWageMny(BigDecimal wageMny) {
        this.wageMny = wageMny;
    }

    public BigDecimal getMarginMny() {
        return marginMny;
    }

    public void setMarginMny(BigDecimal marginMny) {
        this.marginMny = marginMny;
    }

    public BigDecimal getMarginRatio() {
        return marginRatio;
    }

    public void setMarginRatio(BigDecimal marginRatio) {
        this.marginRatio = marginRatio;
    }

    public BigDecimal getMarginActual() {
        return marginActual;
    }

    public void setMarginActual(BigDecimal marginActual) {
        this.marginActual = marginActual;
    }

    public BigDecimal getMarginUnpaid() {
        return marginUnpaid;
    }

    public void setMarginUnpaid(BigDecimal marginUnpaid) {
        this.marginUnpaid = marginUnpaid;
    }

    public Integer getByStages() {
        return byStages;
    }

    public void setByStages(Integer byStages) {
        this.byStages = byStages;
    }

    public BigDecimal getArginUnpaidRatio() {
        return arginUnpaidRatio;
    }

    public void setArginUnpaidRatio(BigDecimal arginUnpaidRatio) {
        this.arginUnpaidRatio = arginUnpaidRatio;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getDirectEmployeeCode() {
        return directEmployeeCode;
    }

    public void setDirectEmployeeCode(Long directEmployeeCode) {
        this.directEmployeeCode = directEmployeeCode;
    }


    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }
}
