package com.ejianc.business.jltest.orgtest.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.foundation.share.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.jltest.orgtest.vo.PlaneDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 安措费使用计划E
 *
 * @author generator
 */
public class PlaneVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 计划发文字号
    private String planName; // 计划发文名称
    private String planUrgent; // 紧急程度 0-特急,1-急、2-一般
    private String planSecret; // 密级 0-公开,1-秘密,2-机密
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planDate; // 计划发文日期
    private BigDecimal planMny; // 拟投入金额
    private String planDescription; // 计划发文说明
    private Long safeteameId; // 安全小组主键
    private String safeteameName; // 安全小组名称
    private String safeteameBillCode; // 安全小组发文字号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date safeteameDate; // 安全小组成立日期
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private String orgCode; // 组织编码
    private Long parentOrgId; // 父级组织
    private String parentOrgName; // 父级组织名称
    private String parentOrgCode; // 父级组织编码
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private String projectCode; // 项目code
    private Long submitId; // 提交人
    private String submitName; // 提交人姓名
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date submitDate; // 提交日期
    private Integer billState; // 单据状态（审批必须字段）

    private List<PlaneDetailVO> planeDetailList = new ArrayList<>(); // 安措费使用计划E明细

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getPlanName() {
        return planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }

    public String getPlanUrgent() {
        return planUrgent;
    }

    public void setPlanUrgent(String planUrgent) {
        this.planUrgent = planUrgent;
    }

    public String getPlanSecret() {
        return planSecret;
    }

    public void setPlanSecret(String planSecret) {
        this.planSecret = planSecret;
    }

    public Date getPlanDate() {
        return planDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }

    public BigDecimal getPlanMny() {
        return planMny;
    }

    public void setPlanMny(BigDecimal planMny) {
        this.planMny = planMny;
    }

    public String getPlanDescription() {
        return planDescription;
    }

    public void setPlanDescription(String planDescription) {
        this.planDescription = planDescription;
    }

    @ReferSerialTransfer(referCode = "safeTeam-e")
    public Long getSafeteameId() {
        return safeteameId;
    }

    @ReferDeserialTransfer
    public void setSafeteameId(Long safeteameId) {
        this.safeteameId = safeteameId;
    }

    public String getSafeteameName() {
        return safeteameName;
    }

    public void setSafeteameName(String safeteameName) {
        this.safeteameName = safeteameName;
    }

    public String getSafeteameBillCode() {
        return safeteameBillCode;
    }

    public void setSafeteameBillCode(String safeteameBillCode) {
        this.safeteameBillCode = safeteameBillCode;
    }

    public Date getSafeteameDate() {
        return safeteameDate;
    }

    public void setSafeteameDate(Date safeteameDate) {
        this.safeteameDate = safeteameDate;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getSubmitId() {
        return submitId;
    }

    public void setSubmitId(Long submitId) {
        this.submitId = submitId;
    }

    public String getSubmitName() {
        return submitName;
    }

    public void setSubmitName(String submitName) {
        this.submitName = submitName;
    }

    public Date getSubmitDate() {
        return submitDate;
    }

    public void setSubmitDate(Date submitDate) {
        this.submitDate = submitDate;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<PlaneDetailVO> getPlaneDetailList() {
        return planeDetailList;
    }

    public void setPlaneDetailList(List<PlaneDetailVO> planeDetailList) {
        this.planeDetailList = planeDetailList;
    }

}
