package com.ejianc.business.jltest.newtest.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.jltest.newtest.vo.BookDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 安全生产责任书
 * 
 * @author generator
 * 
 */
public class BookVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 安全生产责任书号
    private String bookName; // 安全生产责任书名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date bookDate; // 生产时间
    private Long safeteamaId; // 安全小组主键
    private String safeteamaName; // 安全小组发文名称
    private String safeteamaBillCode; // 安全小组成立发文字号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date safeteamaDate; // 安全小组发文日期
    private Long projectId; // 项目
    private String projectName; // 
    private String projectCode; // 项目code
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private String orgCode; // 组织code
    private String parentOrgName; // 
    private String parentOrgCode; // 父级组织编码
    private Long parentOrgId; // 父级组织
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private String memo; // 备注
    private Integer billState; // 单据状态（审批必须字段）
    
    private List<BookDetailVO> bookDetailList = new ArrayList<>(); // 安全生产责任书明细

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getBookName() {
        return bookName;
    }

    public void setBookName(String bookName) {
        this.bookName = bookName;
    }
    public Date getBookDate() {
        return bookDate;
    }

    public void setBookDate(Date bookDate) {
        this.bookDate = bookDate;
    }
    @ReferSerialTransfer(referCode="safeTeam-a")
    public Long getSafeteamaId() {
        return safeteamaId;
    }
    @ReferDeserialTransfer
    public void setSafeteamaId(Long safeteamaId) {
        this.safeteamaId = safeteamaId;
    }
    public String getSafeteamaName() {
        return safeteamaName;
    }

    public void setSafeteamaName(String safeteamaName) {
        this.safeteamaName = safeteamaName;
    }
    public String getSafeteamaBillCode() {
        return safeteamaBillCode;
    }

    public void setSafeteamaBillCode(String safeteamaBillCode) {
        this.safeteamaBillCode = safeteamaBillCode;
    }
    public Date getSafeteamaDate() {
        return safeteamaDate;
    }

    public void setSafeteamaDate(Date safeteamaDate) {
        this.safeteamaDate = safeteamaDate;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
     public List<BookDetailVO> getBookDetailList() {
        return bookDetailList;
     }

     public void setBookDetailList(List<BookDetailVO> bookDetailList) {
        this.bookDetailList = bookDetailList;
     }
}
