package com.ejianc.business.jltest.margin.vo;

import java.sql.Timestamp;
import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import cn.hutool.core.date.DateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 风险金退还
 * 
 * @author generator
 * 
 */
public class MoneyRefundVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long employeeSchedulesId; // 员工明细表id
    private String employeeSchedulesName; // 员工明细表名称
    private String employeeSchedulesCode; // 员工明细billCode
    private BigDecimal due; // 应缴纳金额
    private BigDecimal actualDue; // 实际已缴纳金额
    private BigDecimal cumulativeDue; // 累计已缴纳金额
    private BigDecimal currentPeriodActualDue; // 本期退还/调动金额
    private BigDecimal includeCurrentPeriodActualActualDue; // 含本期实际缴纳金额
    private Integer type; // 当前单据类型（1-退还，2-调动）
    private Integer confirmStatus; // 确认状态（1-待确认，2-确认中，3-已确认）
    @JsonFormat(pattern = "yyyy-MM-dd hh:mm:ss", timezone = "GMT+8")
    private Timestamp confirmTime; // 确认时间
    private String confirmer; // 确认人
    private BigDecimal approvedOutputValue; // 退还/调动前一期审定产值
    private BigDecimal includeCurrentPeriodActualActualPercentage; // 含本期实际缴纳占比
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date refundDate; // 退还/调动日期
    private String mobilizeOrg; // 调动后的组织
    private Long mobilizeOrgId; // 调动后的组织id
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private String projectCode; // 项目code
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private String orgCode; // 组织code
    private String parentOrgName; // 父级组织名称
    private String parentOrgCode; // 父级组织编码
    private Long parentOrgId; // 父级组织
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private String memo; // 备注
    private Integer billState; // 单据状态（审批必须字段）
    private Integer stage; // 是否分期 1-分期 2-不分期
    @TableField(exist = false)
    private String opt; // 确认操作


    public String getMobilizeOrg() {
        return mobilizeOrg;
    }

    public void setMobilizeOrg(String mobilizeOrg) {
        this.mobilizeOrg = mobilizeOrg;
    }

    public Long getMobilizeOrgId() {
        return mobilizeOrgId;
    }

    public void setMobilizeOrgId(Long mobilizeOrgId) {
        this.mobilizeOrgId = mobilizeOrgId;
    }

    public String getOpt() {
        return opt;
    }

    public void setOpt(String opt) {
        this.opt = opt;
    }

    public BigDecimal getCumulativeDue() {
        return cumulativeDue;
    }

    public void setCumulativeDue(BigDecimal cumulativeDue) {
        this.cumulativeDue = cumulativeDue;
    }

    public Integer getConfirmStatus() {
        return confirmStatus;
    }

    public void setConfirmStatus(Integer confirmStatus) {
        this.confirmStatus = confirmStatus;
    }

    public Timestamp getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Timestamp confirmTime) {
        this.confirmTime = confirmTime;
    }

    public String getConfirmer() {
        return confirmer;
    }

    public void setConfirmer(String confirmer) {
        this.confirmer = confirmer;
    }

    public Integer getStage() {
        return stage;
    }

    public void setStage(Integer stage) {
        this.stage = stage;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeSchedulesId() {
        return employeeSchedulesId;
    }

    @ReferDeserialTransfer
    public void setEmployeeSchedulesId(Long employeeSchedulesId) {
        this.employeeSchedulesId = employeeSchedulesId;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public String getEmployeeSchedulesName() {
        return employeeSchedulesName;
    }

    @ReferDeserialTransfer
    public void setEmployeeSchedulesName(String employeeSchedulesName) {
        this.employeeSchedulesName = employeeSchedulesName;
    }
    @ReferSerialTransfer(referCode="idm-direct-employee-detail-ref")
    public String getEmployeeSchedulesCode() {
        return employeeSchedulesCode;
    }

    @ReferDeserialTransfer
    public void setEmployeeSchedulesCode(String employeeSchedulesCode) {
        this.employeeSchedulesCode = employeeSchedulesCode;
    }
    public BigDecimal getDue() {
        return due;
    }

    public void setDue(BigDecimal due) {
        this.due = due;
    }
    public BigDecimal getActualDue() {
        return actualDue;
    }

    public void setActualDue(BigDecimal actualDue) {
        this.actualDue = actualDue;
    }
    public BigDecimal getCurrentPeriodActualDue() {
        return currentPeriodActualDue;
    }

    public void setCurrentPeriodActualDue(BigDecimal currentPeriodActualDue) {
        this.currentPeriodActualDue = currentPeriodActualDue;
    }
    public BigDecimal getIncludeCurrentPeriodActualActualDue() {
        return includeCurrentPeriodActualActualDue;
    }

    public void setIncludeCurrentPeriodActualActualDue(BigDecimal includeCurrentPeriodActualActualDue) {
        this.includeCurrentPeriodActualActualDue = includeCurrentPeriodActualActualDue;
    }
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
    public BigDecimal getApprovedOutputValue() {
        return approvedOutputValue;
    }

    public void setApprovedOutputValue(BigDecimal approvedOutputValue) {
        this.approvedOutputValue = approvedOutputValue;
    }
    public BigDecimal getIncludeCurrentPeriodActualActualPercentage() {
        return includeCurrentPeriodActualActualPercentage;
    }

    public void setIncludeCurrentPeriodActualActualPercentage(BigDecimal includeCurrentPeriodActualActualPercentage) {
        this.includeCurrentPeriodActualActualPercentage = includeCurrentPeriodActualActualPercentage;
    }
    public Date getRefundDate() {
        return refundDate;
    }

    public void setRefundDate(Date refundDate) {
        this.refundDate = refundDate;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
