package com.ejianc.business.jltest.margin.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 缴纳详情表
 * 
 * @author generator
 * 
 */
public class PaymentDetailsVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long employeeDetailId; // 员工明细主键
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private String orgCode; // 组织code
    private BigDecimal payableAmount; // 应缴纳金额
    private BigDecimal currentPaymentAmount; // 本期缴纳金额
    private BigDecimal paymentAmountTotal; // 含本期已缴纳金额
    private BigDecimal proportion; // 含本期已缴纳比例
    private Integer type; // 类型
    private BigDecimal remainingPaymentAmount; // 剩余缴纳金额
    private Integer isStaged; // 是否分期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date paymentDate; // 缴纳日期
    private String memo; // 备注
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private Integer billState; // 单据状态（审批必须字段）
    private String billCode; //缴纳类型
    private Integer confirmationState; //确认状态

    private String typeVo;//字符串类型的 类型

    public String getTypeVo() {
        return typeVo;
    }

    public void setTypeVo(String typeVo) {
        this.typeVo = typeVo;
    }

    public Integer getConfirmationState() {
        return confirmationState;
    }

    public void setConfirmationState(Integer confirmationState) {
        this.confirmationState = confirmationState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode="direct-employee-detail-ref")
    public Long getEmployeeDetailId() {
        return employeeDetailId;
    }
    @ReferDeserialTransfer
    public void setEmployeeDetailId(Long employeeDetailId) {
        this.employeeDetailId = employeeDetailId;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public BigDecimal getPayableAmount() {
        return payableAmount;
    }

    public void setPayableAmount(BigDecimal payableAmount) {
        this.payableAmount = payableAmount;
    }
    public BigDecimal getCurrentPaymentAmount() {
        return currentPaymentAmount;
    }

    public void setCurrentPaymentAmount(BigDecimal currentPaymentAmount) {
        this.currentPaymentAmount = currentPaymentAmount;
    }
    public BigDecimal getPaymentAmountTotal() {
        return paymentAmountTotal;
    }

    public void setPaymentAmountTotal(BigDecimal paymentAmountTotal) {
        this.paymentAmountTotal = paymentAmountTotal;
    }

    public BigDecimal getProportion() {
        return proportion;
    }

    public void setProportion(BigDecimal proportion) {
        this.proportion = proportion;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
    public BigDecimal getRemainingPaymentAmount() {
        return remainingPaymentAmount;
    }

    public void setRemainingPaymentAmount(BigDecimal remainingPaymentAmount) {
        this.remainingPaymentAmount = remainingPaymentAmount;
    }
    public Integer getIsStaged() {
        return isStaged;
    }

    public void setIsStaged(Integer isStaged) {
        this.isStaged = isStaged;
    }
    public Date getPaymentDate() {
        return paymentDate;
    }

    public void setPaymentDate(Date paymentDate) {
        this.paymentDate = paymentDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
