package com.ejianc.business.jltest.margin.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 直管部缴纳员工表
 *
 * @author generator
 */
public class DirectEmployeeVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编码
    private Long standardId; // 标准表ID
    private Long orgId; // 申请组织
    private String orgName; // 组织名称
    private String orgCode; // 组织code
    private Integer year; // 所属年度
    private BigDecimal directMny; // 直管部缴纳金额
    private String standardCode; // 标准表编码
    private BigDecimal employeeMny; // 员工应缴纳金额
    private BigDecimal employeeActualMny; // 员工实际缴纳金额
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称a
    private Integer changeState; //变更状态 1-未变更 2-已变更 3-变更中
    private String memo; // 申请事由
    private Integer billState; // 单据状态（审批必须字段）

    private List<DirectEmployeeDetailVO> detailList = new ArrayList<>(); // 参会人员1

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode = "direct-standard")
    public Long getStandardId() {
        return standardId;
    }

    @ReferDeserialTransfer
    public void setStandardId(Long standardId) {
        this.standardId = standardId;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public BigDecimal getDirectMny() {
        return directMny;
    }

    public void setDirectMny(BigDecimal directMny) {
        this.directMny = directMny;
    }

    public String getStandardCode() {
        return standardCode;
    }

    public void setStandardCode(String standardCode) {
        this.standardCode = standardCode;
    }

    public BigDecimal getEmployeeMny() {
        return employeeMny;
    }

    public void setEmployeeMny(BigDecimal employeeMny) {
        this.employeeMny = employeeMny;
    }

    public BigDecimal getEmployeeActualMny() {
        return employeeActualMny;
    }

    public void setEmployeeActualMny(BigDecimal employeeActualMny) {
        this.employeeActualMny = employeeActualMny;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<DirectEmployeeDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<DirectEmployeeDetailVO> detailList) {
        this.detailList = detailList;
    }

    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }
}
