package com.ejianc.business.jltest.orgtest.vo;

import com.ejianc.business.jltest.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 安措费使用计划A
 *
 * @author generator
 *
 */
public class PlanaListVO extends BaseVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;

    private String billCode; // 安全生产会议发文字号
    private String planaName; // 安措费使用计划发文名称
    private Integer planaUrgency; // 紧急程度（1-特急，2-急，3-一般）
    private Integer planaSecret; //  密级（1-公开，2-秘密，3-机密，4-绝密）
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planaDate; // 安措费使用计划发文日期
    private BigDecimal planaMny; // 拟投入金额
    private Long safeteamaId; // 安全小组主键
    private String safeteamaName; // 安全小组发文名称
    private String safeteamaBillCode; // 安全小组成立发文字号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date safeteamaDate; // 安全小组发文日期
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private String projectCode; // 项目code
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private String orgCode; // 组织code
    private String parentOrgName; //
    private String parentOrgCode; // 父级组织编码
    private Long parentOrgId; // 父级组织
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private String memo; // 安措费使用计发文说明
    private Long submitPeopleId; // 提交人
    private String submitPeopleName; // 提交人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date submitDate; // 提交日期
    private Integer billState; // 单据状态（审批必须字段）
    private Long planaId;//主表主键
    private BigDecimal detailMny; // 拟投入金额
    private String secretName;
    private String urgencyName;

    private List<PlanaDetailVO> planaDetailList = new ArrayList<>(); // 安措费使用计划明细A

    private List<ITreeNodeB> children;
    @Override
    public Long getNodeID() {
        return getId();
    }

    public Long getPlanaId() {
        return planaId;
    }

    public void setPlanaId(Long planaId) {
        this.planaId = planaId;
    }

    public BigDecimal getDetailMny() {
        return detailMny;
    }

    public String getSecretName() {
        return secretName;
    }

    public void setSecretName(String secretName) {
        this.secretName = secretName;
    }

    public String getUrgencyName() {
        return urgencyName;
    }

    public void setUrgencyName(String urgencyName) {
        this.urgencyName = urgencyName;
    }

    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }

    @Override
    public Long getParentID() {
        return planaId;
    }

    @Override
    public String toString() {
        return "PlanaListVO{" +
                "billCode='" + billCode + '\'' +
                ", planaName='" + planaName + '\'' +
                ", planaUrgency=" + planaUrgency +
                ", planaSecret=" + planaSecret +
                ", planaDate=" + planaDate +
                ", planaMny=" + planaMny +
                ", safeteamaId=" + safeteamaId +
                ", safeteamaName='" + safeteamaName + '\'' +
                ", safeteamaBillCode='" + safeteamaBillCode + '\'' +
                ", safeteamaDate=" + safeteamaDate +
                ", projectId=" + projectId +
                ", projectName='" + projectName + '\'' +
                ", projectCode='" + projectCode + '\'' +
                ", orgId=" + orgId +
                ", orgName='" + orgName + '\'' +
                ", orgCode='" + orgCode + '\'' +
                ", parentOrgName='" + parentOrgName + '\'' +
                ", parentOrgCode='" + parentOrgCode + '\'' +
                ", parentOrgId=" + parentOrgId +
                ", employeeId=" + employeeId +
                ", employeeName='" + employeeName + '\'' +
                ", departmentId=" + departmentId +
                ", departmentName='" + departmentName + '\'' +
                ", memo='" + memo + '\'' +
                ", submitPeopleId=" + submitPeopleId +
                ", submitPeopleName='" + submitPeopleName + '\'' +
                ", submitDate=" + submitDate +
                ", billState=" + billState +
                ", planaId=" + planaId +
                ", detailMny=" + detailMny +
                ", planaDetailList=" + planaDetailList +
                ", children=" + children +
                '}';
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getPlanaName() {
        return planaName;
    }

    public void setPlanaName(String planaName) {
        this.planaName = planaName;
    }
    public Integer getPlanaUrgency() {
        return planaUrgency;
    }

    public void setPlanaUrgency(Integer planaUrgency) {
        this.planaUrgency = planaUrgency;
    }
    public Integer getPlanaSecret() {
        return planaSecret;
    }

    public void setPlanaSecret(Integer planaSecret) {
        this.planaSecret = planaSecret;
    }
    public Date getPlanaDate() {
        return planaDate;
    }

    public void setPlanaDate(Date planaDate) {
        this.planaDate = planaDate;
    }
    public BigDecimal getPlanaMny() {
        return planaMny;
    }

    public void setPlanaMny(BigDecimal planaMny) {
        this.planaMny = planaMny;
    }
    @ReferSerialTransfer(referCode="safeTeam-a")
    public Long getSafeteamaId() {
        return safeteamaId;
    }
    @ReferDeserialTransfer
    public void setSafeteamaId(Long safeteamaId) {
        this.safeteamaId = safeteamaId;
    }
    public String getSafeteamaName() {
        return safeteamaName;
    }

    public void setSafeteamaName(String safeteamaName) {
        this.safeteamaName = safeteamaName;
    }
    public String getSafeteamaBillCode() {
        return safeteamaBillCode;
    }

    public void setSafeteamaBillCode(String safeteamaBillCode) {
        this.safeteamaBillCode = safeteamaBillCode;
    }
    public Date getSafeteamaDate() {
        return safeteamaDate;
    }

    public void setSafeteamaDate(Date safeteamaDate) {
        this.safeteamaDate = safeteamaDate;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getSubmitPeopleId() {
        return submitPeopleId;
    }

    public void setSubmitPeopleId(Long submitPeopleId) {
        this.submitPeopleId = submitPeopleId;
    }
    public String getSubmitPeopleName() {
        return submitPeopleName;
    }

    public void setSubmitPeopleName(String submitPeopleName) {
        this.submitPeopleName = submitPeopleName;
    }
    public Date getSubmitDate() {
        return submitDate;
    }

    public void setSubmitDate(Date submitDate) {
        this.submitDate = submitDate;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

     public List<PlanaDetailVO> getPlanaDetailList() {
        return planaDetailList;
     }

     public void setPlanaDetailList(List<PlanaDetailVO> planaDetailList) {
        this.planaDetailList = planaDetailList;
     }
}
