package com.ejianc.business.jltest.margin.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.jltest.margin.vo.DirectPaidEmployeeVO;
import com.ejianc.business.jltest.margin.vo.DirectPaidRecordVO;
import com.ejianc.business.jltest.margin.vo.DirectAllocationRecordVO;

/**
 * 直管部风险金台账
 *
 * @author generator
 */
public class DirectLedgeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    private Long directEmployeeId;

    private String billCode; // 单据编码
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private String orgCode; // 组织code
    private Integer year; // 所属年度
    private BigDecimal payableMny; // 应缴纳金额
    private BigDecimal accumulatedMny; // 累计缴纳金额
    private BigDecimal returnMny;//累计退还金额

    private BigDecimal actualMny; // 实际缴纳金额
    private BigDecimal allotmentMny; // 已分配金额
    private BigDecimal allotmentSumMny;

    private Integer billState; // 单据状态（审批必须字段）

    private List<DirectPaidEmployeeVO> directPaidEmployeeList = new ArrayList<>(); // 直管部台账缴纳人员
    private List<DirectPaidRecordVO> directPaidRecordList = new ArrayList<>(); // 直管部台账缴纳记录
    private List<DirectAllocationRecordVO> directAllocationRecordList = new ArrayList<>(); // 直管部台账分配记录

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public BigDecimal getPayableMny() {
        return payableMny;
    }

    public void setPayableMny(BigDecimal payableMny) {
        this.payableMny = payableMny;
    }

    public BigDecimal getAccumulatedMny() {
        return accumulatedMny;
    }

    public void setAccumulatedMny(BigDecimal accumulatedMny) {
        this.accumulatedMny = accumulatedMny;
    }

    public BigDecimal getActualMny() {
        return actualMny;
    }

    public void setActualMny(BigDecimal actualMny) {
        this.actualMny = actualMny;
    }

    public BigDecimal getAllotmentMny() {
        return allotmentMny;
    }

    public void setAllotmentMny(BigDecimal allotmentMny) {
        this.allotmentMny = allotmentMny;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<DirectPaidEmployeeVO> getDirectPaidEmployeeList() {
        return directPaidEmployeeList;
    }

    public void setDirectPaidEmployeeList(List<DirectPaidEmployeeVO> directPaidEmployeeList) {
        this.directPaidEmployeeList = directPaidEmployeeList;
    }

    public List<DirectPaidRecordVO> getDirectPaidRecordList() {
        return directPaidRecordList;
    }

    public void setDirectPaidRecordList(List<DirectPaidRecordVO> directPaidRecordList) {
        this.directPaidRecordList = directPaidRecordList;
    }

    public List<DirectAllocationRecordVO> getDirectAllocationRecordList() {
        return directAllocationRecordList;
    }

    public void setDirectAllocationRecordList(List<DirectAllocationRecordVO> directAllocationRecordList) {
        this.directAllocationRecordList = directAllocationRecordList;
    }

    public BigDecimal getReturnMny() {
        return returnMny;
    }

    public void setReturnMny(BigDecimal returnMny) {
        this.returnMny = returnMny;
    }

    public Long getDirectEmployeeId() {
        return directEmployeeId;
    }

    public void setDirectEmployeeId(Long directEmployeeId) {
        this.directEmployeeId = directEmployeeId;
    }

    public BigDecimal getAllotmentSumMny() {
        return allotmentSumMny;
    }

    public void setAllotmentSumMny(BigDecimal allotmentSumMny) {
        this.allotmentSumMny = allotmentSumMny;
    }
}
