/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jltest.orgtest.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jltest.orgtest.bean.PlanbEntity;
import com.ejianc.business.jltest.orgtest.bean.SafeteambEntity;
import com.ejianc.business.jltest.orgtest.mapper.PlanbMapper;
import com.ejianc.business.jltest.orgtest.service.IPlanbService;
import com.ejianc.business.jltest.orgtest.service.ISafeteambService;
import com.ejianc.business.jltest.orgtest.vo.PlanbVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="planbService")
public class PlanbServiceImpl
extends BaseServiceImpl<PlanbMapper, PlanbEntity>
implements IPlanbService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ISafeteambService safeteambService;
    private static final String BILL_CODE = "PLAN-B";

    @Override
    public PlanbVO saveUpdate(PlanbVO saveOrUpdateVO) {
        PlanbEntity entity = (PlanbEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PlanbEntity.class));
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PlanbEntity::getOrgId, (Object)saveOrUpdateVO.getOrgId());
        if (entity.getId() != null) {
            lambda.ne(BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        }
        lambda.notIn(PlanbEntity::getBillState, new Object[]{1, 3});
        List entityList2 = super.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)entityList2)) {
            throw new BusinessException("\u5f53\u524d\u7ec4\u7ec7\u5b58\u5728\u672a\u751f\u6548\u7684\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e");
        }
        if ((entity.getId() == null || entity.getId() == 0L) && StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)saveOrUpdateVO.getSafeteambId());
        updateWrapper.set(SafeteambEntity::getMeetingFlag, (Object)2);
        this.safeteambService.update((Wrapper)updateWrapper);
        PlanbVO vo = (PlanbVO)BeanMapper.map((Object)((Object)entity), PlanbVO.class);
        return vo;
    }

    @Override
    public void removeByIdsRewrite(List<PlanbVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(BaseEntity::getId, ids);
            List planaEntities = super.list((Wrapper)queryWrapper);
            List safeteamaIds = planaEntities.stream().map(PlanbEntity::getSafeteambId).collect(Collectors.toList());
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(BaseEntity::getId, safeteamaIds);
            updateWrapper.set(SafeteambEntity::getMeetingFlag, (Object)1);
            this.safeteambService.update((Wrapper)updateWrapper);
        }
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
    }
}

