/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jltest.orgtest.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.ejianc.business.jltest.orgtest.bean.DangeraEntity;
import com.ejianc.business.jltest.orgtest.bean.PlanaEntity;
import com.ejianc.business.jltest.orgtest.bean.SafeTeamaEntity;
import com.ejianc.business.jltest.orgtest.service.IDangeraService;
import com.ejianc.business.jltest.orgtest.service.IPlanaService;
import com.ejianc.business.jltest.orgtest.service.ISafeTeamaService;
import com.ejianc.business.jltest.orgtest.vo.DangeraVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="plana")
public class PlanaBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private ISafeTeamaService safeTeamaService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPlanaService planaService;
    @Autowired
    private IDangeraService dangeraService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "DANGER_CODE";

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        if (state == 1) {
            this.logger.info("\u589e\u52a0\u63d0\u4ea4\u4eba \u63d0\u4ea4\u65e5\u671f\u53c2\u6570");
            PlanaEntity plana = (PlanaEntity)((Object)this.planaService.getById(billId));
            plana.setSubmitPeopleId(this.sessionManager.getUserContext().getEmployeeId());
            plana.setSubmitPeopleName(this.sessionManager.getUserContext().getEmployeeName());
            plana.setSubmitDate(new Date());
            this.planaService.updateById((Object)plana);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PlanaEntity plana = (PlanaEntity)((Object)this.planaService.getById(billId));
        this.logger.info("\u66f4\u6539\u4e0a\u6e38\u6570\u636e\u4fe1\u606f");
        SafeTeamaEntity safeTeama = (SafeTeamaEntity)((Object)this.safeTeamaService.selectById(plana.getSafeteamaId()));
        safeTeama.setMeetingFlag(1);
        this.safeTeamaService.updateById((Object)safeTeama);
        this.logger.info("\u751f\u6210  \u91cd\u5927\u4e8b\u6545\u9690\u60a3\u5224\u65ad (\u81ea\u7531\u6001)");
        DangeraVO dangeraVO = new DangeraVO();
        dangeraVO.setOrgId(plana.getOrgId());
        dangeraVO.setOrgName(plana.getOrgName());
        dangeraVO.setOrgCode(plana.getOrgCode());
        dangeraVO.setDangeraName(plana.getPlanaName());
        dangeraVO.setDangeraDate(plana.getPlanaDate());
        dangeraVO.setEmployeeId(plana.getEmployeeId());
        dangeraVO.setEmployeeName(plana.getEmployeeName());
        dangeraVO.setDepartmentId(plana.getDepartmentId());
        dangeraVO.setDepartmentName(plana.getDepartmentName());
        dangeraVO.setCreateTime(new Date());
        dangeraVO.setBillType(Integer.valueOf(1));
        dangeraVO.setPlanId(plana.getId());
        DangeraEntity dangera = (DangeraEntity)((Object)BeanMapper.map((Object)dangeraVO, DangeraEntity.class));
        BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)dangeraVO);
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        dangera.setBillCode((String)billCode.getData());
        this.dangeraService.saveOrUpdate((Object)dangera, false);
        this.logger.info("\u590d\u5236\u9644\u4ef6");
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(plana.getId().toString(), "EJCBT202403000025", "plana2", dangera.getId().toString(), "EJCBT202403000026", "dangera2");
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DangeraEntity::getPlanId, (Object)billId);
        queryWrapper.eq(DangeraEntity::getBillType, (Object)1);
        queryWrapper.eq(BaseEntity::getDr, (Object)0);
        DangeraEntity dangera = (DangeraEntity)((Object)this.dangeraService.getOne((Wrapper)queryWrapper));
        if (!ObjectUtils.isEmpty((Object)((Object)dangera))) {
            if (dangera.getBillState() == 1 && dangera.getBillState() == 3) {
                return CommonResponse.error((String)"\u5f53\u524d\u5355\u5b50\u5df2\u5b58\u5728\u4e0b\u6e38\u6570\u636e\uff0c\u4e0d\u80fd\u5220\u9664");
            }
        } else {
            return CommonResponse.error((String)"\u6ca1\u6709\u751f\u6210\u5bf9\u5e94\u6570\u636e");
        }
        PlanaEntity planaEntity = (PlanaEntity)((Object)this.planaService.getById(billId));
        planaEntity.setBillState(0);
        this.planaService.updateById((Object)planaEntity);
        dangera.setDr(1);
        this.dangeraService.updateById((Object)dangera);
        this.logger.info("\u64a4\u56de\u540e  \u4e0a\u6e38\u6570\u636eflag\u72b6\u6001\u6539\u4e3a2");
        PlanaEntity plana = (PlanaEntity)((Object)this.planaService.getById(billId));
        SafeTeamaEntity safeTeama = (SafeTeamaEntity)((Object)this.safeTeamaService.getById(plana.getSafeteamaId()));
        safeTeama.setMeetingFlag(2);
        this.safeTeamaService.updateById((Object)safeTeama);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

