/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jltest.orgtest.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.jltest.orgtest.bean.PlanaEntity;
import com.ejianc.business.jltest.orgtest.bean.SafeTeamaEntity;
import com.ejianc.business.jltest.orgtest.mapper.PlanaMapper;
import com.ejianc.business.jltest.orgtest.service.IPlanaService;
import com.ejianc.business.jltest.orgtest.service.ISafeTeamaService;
import com.ejianc.business.jltest.orgtest.vo.PlanaVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="planaService")
public class PlanaServiceImpl
extends BaseServiceImpl<PlanaMapper, PlanaEntity>
implements IPlanaService {
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "PLAN_CODE";
    @Autowired
    private ISafeTeamaService safeTeamaService;

    @Override
    public PlanaVO saveUpdate(PlanaVO saveOrUpdateVO) {
        PlanaEntity entity = (PlanaEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PlanaEntity.class));
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(PlanaEntity::getOrgId, (Object)saveOrUpdateVO.getOrgId());
        if (entity.getId() != null) {
            lambdaQueryWrapper.ne(BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        }
        lambdaQueryWrapper.notIn(PlanaEntity::getBillState, new Object[]{1, 3});
        List listByBillState = super.list((Wrapper)lambdaQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)listByBillState)) {
            throw new BusinessException("\u5f53\u524d\u7ec4\u7ec7\u5b58\u5728\u672a\u751f\u6548\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e");
        }
        if ((entity.getId() == null || entity.getId() == 0L) && StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)saveOrUpdateVO.getSafeteamaId());
        updateWrapper.set(SafeTeamaEntity::getMeetingFlag, (Object)2);
        this.safeTeamaService.update((Wrapper)updateWrapper);
        PlanaVO vo = (PlanaVO)BeanMapper.map((Object)((Object)entity), PlanaVO.class);
        return vo;
    }

    @Override
    public void removeByIdsRewrite(List<PlanaVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(BaseEntity::getId, ids);
            List planaEntities = super.list((Wrapper)queryWrapper);
            List safeteamaIds = planaEntities.stream().map(PlanaEntity::getSafeteamaId).collect(Collectors.toList());
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(BaseEntity::getId, safeteamaIds);
            updateWrapper.set(SafeTeamaEntity::getMeetingFlag, (Object)1);
            this.safeTeamaService.update((Wrapper)updateWrapper);
        }
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
    }
}

