package com.ejianc.business.jltest.orgtest.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jltest.orgtest.bean.MeetingEntity;
import com.ejianc.business.jltest.orgtest.bean.SafeTeamaEntity;
import com.ejianc.business.jltest.orgtest.bean.SafeteambEntity;
import com.ejianc.business.jltest.orgtest.service.ISafeTeamaService;
import com.ejianc.business.jltest.orgtest.service.ISafeteambService;
import com.ejianc.business.jltest.orgtest.vo.MeetingVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.search.aggregations.bucket.terms.UnmappedTerms;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jltest.orgtest.bean.PlanbEntity;
import com.ejianc.business.jltest.orgtest.service.IPlanbService;
import com.ejianc.business.jltest.orgtest.vo.PlanbVO;

/**
 * 安措费使用计划B
 *
 * @author generator
 */
@Controller
@RequestMapping("planb")
public class PlanbController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PLAN-B";// 此处需要根据实际修改

    @Autowired
    private IPlanbService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ISafeteambService safeteambService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PlanbVO> saveOrUpdate(@RequestBody PlanbVO saveOrUpdateVO) {

        return CommonResponse.success("保存或修改单据成功！", service.saveUpdate(saveOrUpdateVO));
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlanbVO> queryDetail(Long id) {
        PlanbEntity entity = service.selectById(id);
        PlanbVO vo = BeanMapper.map(entity, PlanbVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlanbVO> vos) {
        service.removeByIdsRewrite(vos);

        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PlanbVO>> queryList(@RequestBody QueryParam param) {

        // 获取当前 登陆人的 姓名
        String employeeName = sessionManager.getUserContext().getEmployeeName();

        // 获取整个map参数
        Map<String, Parameter> params = param.getParams();
        for (Map.Entry<String, Parameter> stringParameterEntry : params.entrySet()) {

            // 获取key
            String key = stringParameterEntry.getKey();
            // System.out.println("kkkkkkkkkkkkkkk :"+key);

            Parameter value = stringParameterEntry.getValue();
            // 获取value
            Object value1 = value.getValue();
            // System.out.println("vvvvvvvv:"+value1);
            if (key.equals("employeeName") && value1.equals("yes")) {
                param.getParams().put("employeeName", new Parameter(QueryParam.EQ, employeeName));
            }
            if (key.equals("employeeName") && value1.equals("no")) {
                param.getParams().put("employeeName", new Parameter(QueryParam.NE, employeeName));
            }
        }

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("safeteambId");
        fuzzyFields.add("planbName");
        fuzzyFields.add("planbMny");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        // 当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {// 移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {// pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        // 普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        // 项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                // 项目部
                departmentIds.add(org.getId());
            } else {
                // 普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PlanbEntity> page = service.queryPage(param, false);
        IPage<PlanbVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlanbVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {

        // 获取当前 登陆人的 姓名
        String employeeName = sessionManager.getUserContext().getEmployeeName();

        // 获取整个map参数
        Map<String, Parameter> params = param.getParams();
        for (Map.Entry<String, Parameter> stringParameterEntry : params.entrySet()) {

            // 获取key
            String key = stringParameterEntry.getKey();
            // System.out.println("kkkkkkkkkkkkkkk :"+key);

            Parameter value = stringParameterEntry.getValue();
            // 获取value
            Object value1 = value.getValue();
            // System.out.println("vvvvvvvv:"+value1);
            if (key.equals("employeeName") && value1.equals("yes")) {
                param.getParams().put("employeeName", new Parameter(QueryParam.EQ, employeeName));
            }
            if (key.equals("employeeName") && value1.equals("no")) {
                param.getParams().put("employeeName", new Parameter(QueryParam.NE, employeeName));
            }
        }
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("safeteambId");
        fuzzyFields.add("planbName");
        fuzzyFields.add("planbMny");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PlanbEntity> list = service.queryList(param);
        // todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Planb-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPlanbData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PlanbVO>> refPlanbData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                       String condition,
                                                       String searchObject,
                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PlanbEntity> page = service.queryPage(param, false);
        IPage<PlanbVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlanbVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
