package com.ejianc.business.jltest.orgtest.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.ejianc.business.jltest.orgtest.bean.*;
import com.ejianc.business.jltest.orgtest.mapper.DangerbMapper;
import com.ejianc.business.jltest.orgtest.mapper.PlanbMapper;
import com.ejianc.business.jltest.orgtest.service.ISafeTeamaService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.esotericsoftware.minlog.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.Map;

@Service("planb")
public class PlanbBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private PlanbMapper planbMapper;

    @Autowired
    private PlanbServiceImpl planbService;

    @Autowired
    private DangerbServiceImpl dangerbService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private DangerbMapper dangerbMapper;

    @Autowired
    private SafeteambServiceImpl safeTeambService;
    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        // TODO

        return CommonResponse.success();

    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        // TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批后回调
     *
     * @param billId       //单据id
     * @param state        //单据状态
     * @param billTypeCode //单据类型code
     * @param taskId       //该流程id
     * @param isEnd        //该节点是否结束
     * @return
     */
    @Override
    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();

    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        // TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        if (state == 1) {
            // 提交前设置 提交人的信息
            String employeeName = null;
            try {
                logger.info("开始更新 提交人");
                employeeName = sessionManager.getUserContext().getEmployeeName();
                // 先查出planb单子
                PlanbEntity planbEntity = planbService.selectById(billId);
                planbEntity.setCommitPeopleName(employeeName);
              //  planbEntity.setCommitPeopleId(Math.toIntExact(sessionManager.getUserContext().getEmployeeId()));
                planbEntity.setCommitDate(new Date());
                planbMapper.updateById(planbEntity);
            } catch (Exception e) {
                logger.error("beforeSubmitProcessor B-失败，employeeName：{}", employeeName, e);
                return CommonResponse.error("设置提交人信息失败");
            } finally {
                try {
                    // 这里写设置 下游单据的数据
                    // 生成  重大事故隐患判断 (自由态)
                    PlanbEntity planbEntity = planbService.selectById(billId);
                    DangerbEntity dangerb = new DangerbEntity();
                    dangerb.setId(planbEntity.getId());
                    dangerb.setOrgId(planbEntity.getOrgId());
                    dangerb.setBillCode(planbEntity.getBillCode());
                    dangerb.setOrgName(planbEntity.getOrgName());
                    dangerb.setOrgCode(planbEntity.getOrgCode());
                    dangerb.setDangerbName(planbEntity.getPlanbName());
                    dangerb.setDangerbDate(planbEntity.getPlanbDate());
                    dangerb.setEmployeeName(planbEntity.getEmployeeName());
                    dangerb.setDepartmentId(planbEntity.getDepartmentId());
                    dangerb.setDepartmentName(planbEntity.getDepartmentName());
                    dangerb.setTenantId(999999L);
                    dangerb.setEmployeeId(sessionManager.getUserContext().getEmployeeId());
                    dangerb.setBillState(0);
                    dangerbService.saveOrUpdate(dangerb,false);

                    logger.info("复制附件");
                    attachmentApi.copyFilesFromSourceBillToTargetBill(planbEntity.getId().toString(),"EJCBT202403000020","planb",dangerb.getId().toString(),"EJCBT202403000031","dangerb");


                } catch (Exception e) {
                    logger.error("dangerb 表 插入数据失败");
                    throw new RuntimeException(e);
                }

                return CommonResponse.success();
            }
        }
        return CommonResponse.success();
    }


    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {

        //先查看dangerb的billState。如果是已经提交。那么planb也不能撤回
        LambdaQueryWrapper<DangerbEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(DangerbEntity::getId,billId);
        wrapper.eq(DangerbEntity::getDr,0);
        DangerbEntity dangerbEntity = dangerbMapper.selectOne(wrapper);
        if(!ObjectUtils.isEmpty(dangerbEntity)){
            //不为空的时候 判断下游单据的 状态
            if(dangerbEntity.getBillState()==1 ||dangerbEntity.getBillState()==3){
                return CommonResponse.error("下游存在引用数据已提交，无法删除");
            }else {
                //设置中游 状态是自由态
                PlanbEntity planbEntity = planbService.selectById(billId);
                planbEntity.setBillState(0);//自由态状态设置

                //删除下游数据
                dangerbService.removeById(dangerbEntity.getId());
            }
        }
        // 撤回后  上游数据flag状态改为2
        logger.info("撤回后  上游数据flag状态改为2");
        PlanbEntity planbEntity = planbService.getById(billId);
        SafeteambEntity safeTeamb = safeTeambService.getById(planbEntity.getSafeteambId());
        safeTeamb.setMeetingFlag(2);
        safeTeambService.updateById(safeTeamb);


        // TODO
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        // TODO
        return CommonResponse.success();
    }

}
