package com.ejianc.business.jltest.orgtest.service.impl;

import com.ejianc.business.jltest.orgtest.bean.DangerdEntity;
import com.ejianc.business.jltest.orgtest.bean.PlandEntity;
import com.ejianc.business.jltest.orgtest.bean.SafeteamdEntity;
import com.ejianc.business.jltest.orgtest.mapper.PlandMapper;
import com.ejianc.business.jltest.orgtest.service.IDangerdService;
import com.ejianc.business.jltest.orgtest.service.IPlandService;
import com.ejianc.business.jltest.orgtest.service.ISafeteambService;
import com.ejianc.business.jltest.orgtest.service.ISafeteamdService;
import com.ejianc.framework.auth.session.SessionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.Map;

@Service("pland") 
public class PlandBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IPlandService plandService;
	@Autowired
	private IDangerdService dangerdService;
	@Autowired
	private ISafeteamdService safeteamdService;
	@Autowired
	private SessionManager sessionManager;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//提交时填充提交人和提交时间
		PlandEntity plandEntity = plandService.selectById(billId);
		plandEntity.setSubmitName(sessionManager.getUserContext().getEmployeeName());
		plandEntity.setSubmitTime(new Date());
		plandService.updateById(plandEntity);

		SafeteamdEntity safeteamd = safeteamdService.selectById(plandEntity.getSafeteamdId());
		safeteamd.setPlanFlag(2);
		safeteamdService.updateById(safeteamd);

		//生成重大事故隐患判断单据
		DangerdEntity dangerd = new DangerdEntity();
		dangerd.setOrgId(plandEntity.getOrgId());
		dangerd.setOrgName(plandEntity.getOrgName());
		dangerd.setOrgCode(plandEntity.getOrgCode());
		dangerd.setDangerName(plandEntity.getPlanName());
		dangerd.setSelfCheckDate(plandEntity.getPlanDate());
		dangerd.setEmployeeId(plandEntity.getEmployeeId());
		dangerd.setEmployeeName(plandEntity.getEmployeeName());
		dangerd.setDepartmentId(plandEntity.getDepartmentId());
		dangerd.setDepartmentName(plandEntity.getDepartmentName());
		dangerd.setBillState(1);
		dangerdService.saveOrUpdate(dangerd);

		return CommonResponse.success();

	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
