package com.ejianc.business.jltest.orgtest.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.jltest.orgtest.bean.*;
import com.ejianc.business.jltest.orgtest.service.*;
import com.ejianc.business.jltest.orgtest.vo.DangereVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.Map;

@Service("plane")
public class PlaneBpmServiceImpl implements ICommonBusinessService {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IPlaneService planeService;
    @Autowired
    private ISafeteameService safeteameService;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IDangereService dangereService;

    private static final String BILL_CODE = "DANGERE_CODE";//此处需要根据实际修改
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批后回调
     *
     * @param billId       //单据id
     * @param state        //单据状态
     * @param billTypeCode //单据类型code
     * @param taskId       //该流程id
     * @param isEnd        //该节点是否结束
     * @return
     */
    //@Override
    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        if (state == 1) {
            logger.info("提交后，更新提交人和提交日期");
            PlaneEntity planeEntity = planeService.selectById(billId);
            planeEntity.setSubmitName(sessionManager.getUserContext().getEmployeeName());
            planeEntity.setSubmitDate(new Date());
            planeService.updateById(planeEntity);
            logger.info("成功更新提交人和提交日期");

            //生成下游单据 重大事故隐患判定表
            DangereEntity dangereEntity = new DangereEntity();
            DangereVO dangereVO = new DangereVO();
            //为DangereEntity赋值
            //生成BillCode
            logger.info("开始生成BillCode");
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), dangereVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                dangereEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                logger.info("billCode生成异常，计划C审批生成隐患判定C失败");
            }
            dangereEntity.setDangerName(planeEntity.getPlanName()+"重大事故隐患判断");
            dangereEntity.setDangerDate(planeEntity.getPlanDate());
            dangereEntity.setDangerDescription(planeEntity.getPlanDescription());
            dangereEntity.setOrgId(planeEntity.getOrgId());
            dangereEntity.setOrgName(planeEntity.getOrgName());
            dangereEntity.setOrgCode(planeEntity.getOrgCode());
            dangereEntity.setParentOrgId(planeEntity.getParentOrgId());
            dangereEntity.setParentOrgName(planeEntity.getParentOrgName());
            dangereEntity.setEmployeeId(planeEntity.getEmployeeId());
            dangereEntity.setEmployeeName(planeEntity.getEmployeeName());
            dangereEntity.setDepartmentId(planeEntity.getDepartmentId());
            dangereEntity.setDepartmentName(planeEntity.getDepartmentName());
            dangereEntity.setBillState(0);

            //保存重大事故隐患判定表
            logger.info("保存重大事故隐患判定表");
            dangereService.saveOrUpdate(dangereEntity,false);
        }


        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
