/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jltest.orgtest.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jltest.orgtest.bean.PlaneEntity;
import com.ejianc.business.jltest.orgtest.bean.SafeteameEntity;
import com.ejianc.business.jltest.orgtest.service.IPlaneService;
import com.ejianc.business.jltest.orgtest.service.ISafeteameService;
import com.ejianc.business.jltest.orgtest.vo.PlaneVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"plane"})
public class PlaneController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PLANE";
    @Autowired
    private IPlaneService service;
    @Autowired
    private ISafeteameService safeteameService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PlaneVO> saveOrUpdate(@RequestBody PlaneVO saveOrUpdateVO) {
        PlaneEntity entity = (PlaneEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PlaneEntity.class));
        if (!(entity.getId() != null && entity.getId() != 0L || entity.getBillCode() != null && !entity.getBillCode().equals(""))) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.logger.info("\u8bbe\u7f6e\u88ab\u9009\u62e9\u7684\u5b89\u5168\u5c0f\u7ec4\u4e3a\u5f15\u7528\u72b6\u6001 planFlag=1");
        System.out.println("\u5f53\u524d\u5c0f\u7ec4\uff1a" + saveOrUpdateVO.getSafeteameId());
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)saveOrUpdateVO.getSafeteameId());
        updateWrapper.set(SafeteameEntity::getPlanFlag, (Object)1);
        boolean update = this.safeteameService.update((Wrapper)updateWrapper);
        if (update) {
            this.logger.info("\u6210\u529f\u5c06\u5f53\u524d\u5c0f\u7ec4\u8bbe\u7f6e\u4e3a\u5f15\u7528\u72b6\u6001");
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(3);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orgId", new Parameter("eq", (Object)saveOrUpdateVO.getOrgId()));
        if (entity.getId() != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)saveOrUpdateVO.getId()));
        }
        queryParam.getParams().put("billState", new Parameter("not_in", list));
        List entityList = this.service.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            throw new BusinessException("\u5f53\u524d\u7ec4\u7ec7\u5b58\u5728\u672a\u751f\u6548\u7684\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e");
        }
        this.service.saveOrUpdate((Object)entity, false);
        PlaneVO vo = (PlaneVO)BeanMapper.map((Object)((Object)entity), PlaneVO.class);
        vo.setSubmitName(this.sessionManager.getUserContext().getEmployeeName());
        vo.setSubmitId(this.sessionManager.getUserContext().getEmployeeId());
        vo.setSubmitDate(new Date());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PlaneVO> queryDetail(Long id) {
        System.out.println(id);
        PlaneEntity entity = (PlaneEntity)((Object)this.service.selectById(id));
        PlaneVO vo = (PlaneVO)BeanMapper.map((Object)((Object)entity), PlaneVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlaneVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PlaneVO object : vos) {
            }
        }
        this.logger.info("\u5220\u9664\u65f6\u5c06\u4e0a\u6e38\u5355\u636e\u72b6\u6001\u6539\u4e3a0\uff08\u672a\u88ab\u5f15\u7528\uff09");
        ArrayList<Long> ids = new ArrayList<Long>();
        for (PlaneVO vo : vos) {
            ids.add(vo.getId());
        }
        this.logger.info("\u904d\u5386PlaneVO\u83b7\u53d6\u5220\u9664\u7684ids");
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(BaseEntity::getId, ids);
        List planeEntities = this.service.list((Wrapper)lambdaQueryWrapper);
        ArrayList<Long> safeteameIds = new ArrayList<Long>();
        for (PlaneEntity planeEntity : planeEntities) {
            safeteameIds.add(planeEntity.getSafeteameId());
        }
        LambdaUpdateWrapper safeteameUpdateWrapper = new LambdaUpdateWrapper();
        safeteameUpdateWrapper.in(BaseEntity::getId, safeteameIds);
        safeteameUpdateWrapper.set(SafeteameEntity::getPlanFlag, (Object)0);
        boolean update = this.safeteameService.update((Wrapper)safeteameUpdateWrapper);
        if (update) {
            this.logger.info("\u6210\u529f\u5c06\u4e0a\u6e38\u5355\u636e\u72b6\u6001\u6539\u4e3a0\uff08\u672a\u5f15\u7528\uff09");
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PlaneVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        if (param.getParams().get("employeeId") != null) {
            Boolean isCurrentEmployee = (Boolean)((Parameter)param.getParams().get("employeeId")).getValue();
            if (isCurrentEmployee.booleanValue()) {
                this.logger.info("\u7b5b\u9009\u6761\u4ef6:\u7ecf\u529e\u4eba\u4e3a\u5f53\u524d\u767b\u5f55\u4eba");
                Long employeeId = this.sessionManager.getUserContext().getEmployeeId();
                param.getParams().put("employeeId", new Parameter("eq", (Object)employeeId));
            } else {
                param.getParams().remove("employeeId");
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PlaneVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Plane-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPlaneData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PlaneVO>> refPlaneData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PlaneVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

