package com.ejianc.business.jltest.orgtest.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jltest.orgtest.bean.*;
import com.ejianc.business.jltest.orgtest.service.IPlandDetailService;
import com.ejianc.business.jltest.orgtest.service.ISafeteamdService;
import com.ejianc.business.jltest.orgtest.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jltest.orgtest.service.IPlandService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 安措费使用计划D
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("pland")
public class PlandController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PLAND_CODE";//此处需要根据实际修改

    @Autowired
    private IPlandService service;
    @Autowired
    private IPlandDetailService detailService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ISafeteamdService safeteamdService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PlandVO> saveOrUpdate(@RequestBody PlandVO saveOrUpdateVO) {
    	PlandEntity entity = BeanMapper.map(saveOrUpdateVO, PlandEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveUpdate(saveOrUpdateVO);
    	service.saveOrUpdate(entity, false);
    	PlandVO vo = BeanMapper.map(entity, PlandVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlandVO> queryDetail(Long id) {
    	PlandEntity entity = service.selectById(id);
    	PlandVO vo = BeanMapper.map(entity, PlandVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlandVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
//            for (PlandVO vo : vos) {
//                // 参数是单据类型编码字符串 根据需求是否打开下面代码
//                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
//                if(!resp.isSuccess()){
//                    return CommonResponse.error("删除失败！"+resp.getMsg());
//                }*/
//            }
            List<Long> ids = vos.stream().map(PlandVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper<PlandEntity> lambda = Wrappers.<PlandEntity>lambdaQuery();
            lambda.in(PlandEntity::getId, ids);
            List<PlandEntity> plandEntityList = service.list(lambda);
            List<Long> safeteamdIds = plandEntityList.stream().map(PlandEntity::getSafeteamdId).collect(Collectors.toList());
            LambdaUpdateWrapper<SafeteamdEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(SafeteamdEntity::getId, safeteamdIds);
            updateWrapper.set(SafeteamdEntity::getPlanFlag,1);
            safeteamdService.update(updateWrapper);
        }
        service.removeByIds(vos.stream().map(PlandVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PlandTreeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();

        if(param.getParams().get("employeeId") != null){
            Long employeeId = sessionManager.getUserContext().getEmployeeId();
            if ((Boolean) param.getParams().get("employeeId").getValue()){
                param.getParams().put("employeeId",new Parameter(QueryParam.EQ,employeeId));
            }else{
                param.getParams().put("employeeId",new Parameter(QueryParam.NE,employeeId));
            }
            param.getParams().remove("employeeId");
        }
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PlandEntity> page = service.queryPage(param,false);
        IPage<PlandTreeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<PlandTreeVO> resDatas = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(page.getRecords())) {
            resDatas = BeanMapper.mapList(page.getRecords(), PlandTreeVO.class);
            List<Long> ids = new ArrayList<>();
            Map<Long,Integer> map = new HashMap<>();
            if(CollectionUtils.isNotEmpty(resDatas)) {
                resDatas.forEach(e -> {
                    ids.add(e.getId());
                    map.put(e.getId(), e.getBillState());
                });
            }
            LambdaQueryWrapper<PlandDetailEntity> lambda = Wrappers.<PlandDetailEntity>lambdaQuery();
            lambda.in(PlandDetailEntity::getPlandId,ids);
            List<PlandDetailEntity> resList = detailService.list(lambda);
            List<PlandTreeVO> plandTreeVOList = BeanMapper.mapList(resList, PlandTreeVO.class);
            if(CollectionUtils.isNotEmpty(plandTreeVOList)){
                plandTreeVOList.forEach(e->{
                    e.setBillState(map.get(e.getPlandId()));
                    e.setProjectName(e.getProjectName());
                    e.setUsetime(e.getUsetime());
                    e.setProposedInvestmentMny(e.getProposedInvestmentMny());
                });
                resDatas.addAll(plandTreeVOList);
            }
            pageData.setRecords(TreeNodeBUtil.buildTree(resDatas));
            return CommonResponse.success("查询列表数据成功！",pageData);
        }else{
            pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlandTreeVO.class));
            return CommonResponse.success("查询列表数据成功！",pageData);
        }
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        List<Long> ids = new ArrayList<>();

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PlandEntity> list = service.queryList(param);
        List<PlandTreeVO> resDatas = new ArrayList<>();
        Map<Long, Integer> map = new HashMap<>();
        Map<String, Object> beans = new HashMap<>();
        if (CollectionUtils.isNotEmpty(list)) {
            resDatas = BeanMapper.mapList(list, PlandTreeVO.class);
            if (CollectionUtils.isNotEmpty(resDatas)) {
                resDatas.forEach(e -> {
                    ids.add(e.getId());
                    map.put(e.getId(), e.getBillState());
                });
            }
            LambdaQueryWrapper<PlandDetailEntity> lambda = Wrappers.<PlandDetailEntity>lambdaQuery();
            lambda.in(PlandDetailEntity::getPlandId, ids);
            List<PlandDetailEntity> resList = detailService.list(lambda);
            List<PlandTreeVO> plandTreeVOList = BeanMapper.mapList(resList, PlandTreeVO.class);
            if (CollectionUtils.isNotEmpty(plandTreeVOList)) {
                plandTreeVOList.forEach(e -> {
                    e.setBillState(map.get(e.getPlandId()));
                    e.setProjectName(e.getProjectName());
                    e.setUsetime(e.getUsetime());
                    e.setProposedInvestmentMny(e.getProposedInvestmentMny());
                });
                resDatas.addAll(plandTreeVOList);
            }
            resDatas = TreeNodeBUtil.buildTree(resDatas);

            beans.put("records", resDatas);
        } else {
            beans.put("records", resDatas);
        }
//        ExcelExport.getInstance().export("Pland-export.xlsx", beans, response);
        //字段翻译
        for (PlandTreeVO entity : resDatas) {
            switch (entity.getUrgency()) {
                case 0:
                    entity.setUrgencyName("一般");
                    break;
                case 1:
                    entity.setUrgencyName("急");
                    break;
                case 2:
                    entity.setUrgencyName("特急");
                    break;
            }
            switch (entity.getSecretLevel()) {
                case 0:
                    entity.setSecretLevelName("公开");
                    break;
                case 1:
                    entity.setSecretLevelName("秘密");
                    break;
                case 2:
                    entity.setSecretLevelName("机密");
                    break;
                case 3:
                    entity.setSecretLevelName("绝密");
                    break;
            }
        }
        ExcelExport.getInstance().export("PlandTree-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPlandData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PlandVO>> refPlandData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PlandEntity> page = service.queryPage(param,false);
        IPage<PlandVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlandVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadInfo")
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "PlandDetail-import.xlsx", "明细模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<PlandDetailVO> successList = new ArrayList<>();
        List<PlandDetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            String minMny;
            String maxMny;
            if (result != null && result.size() > 0) {
                //获取物资档案数据
//                List<String> materialCodeList = new ArrayList<>();
//                Map<String,MaterialVO> map = new HashMap<>();
//                for (int i = 1; i < result.size(); i++) {
//                    List<String> datas = result.get(i);
//                    materialCodeList.add(datas.get(0));//取材料编码  用来校验
//                }
//                CommonResponse<List<MaterialVO>> materialRes =  materialApi.queryMaterialListByCodes(materialCodeList);
//                if(!materialRes.isSuccess()){
//                    return CommonResponse.error(materialRes.getMsg());
//                }
//                map = materialRes.getData().stream().collect(Collectors.toMap(p -> p.getCode(), Function.identity()));
//                for (int i = 1; i < result.size(); i++) {
//                    List<String> datas = result.get(i);
//                    MeetingDetailVO detailVO = new MeetingDetailVO();
//                    detailVO.setId(com.ejianc.support.idworker.util.IdWorker.getId());
//                    String materialCode = datas.get(0);
//                    detailVO.setMaterialCode(materialCode);
//                    if(map.containsKey(materialCode)){
//                        MaterialVO materialVO =   map.get(materialCode);
//                        detailVO.setMaterialTypeId(materialVO.getCategoryId());
//                        detailVO.setMaterialTypeName(materialVO.getCategoryName());
//                        detailVO.setMaterialId(materialVO.getId());
//                        detailVO.setMaterialName(materialVO.getName());
//                        detailVO.setSpec(materialVO.getSpec());
//                        detailVO.setUnitId(materialVO.getUnitId());
//                        detailVO.setUnitName(materialVO.getUnitName());
//                    }else{
//                        detailVO.setErrorMsg("材料编码不匹配！");
//                        errorList.add(detailVO);
//                        continue;
//                    }
                    for (int i = 1; i < result.size(); i++) {
                        List<String> datas = result.get(i);
                        PlandDetailVO detailVO = new PlandDetailVO();
                        detailVO.setId(com.ejianc.support.idworker.util.IdWorker.getId());
                        String plandName = datas.get(0);
                        detailVO.setProjectName(plandName);
                        //设置最小拟投入金额
                    try {
                        minMny = datas.get(1);
                        detailVO.setProposedInvestmentMny(StringUtils.isNotBlank(minMny) ? new BigDecimal(minMny) : null);
                    }
                    catch (Exception e) {
                        detailVO.setErrMsg("最小拟投入金额错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                        //设置最大拟投入金额
                    try {
                        maxMny = datas.get(2);
                        detailVO.setMaxProposedInvestmentMny(StringUtils.isNotBlank(maxMny) ? new BigDecimal(maxMny) : null);
                    }
                    catch (Exception e) {
                        detailVO.setErrMsg("最大拟投入金额错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                        //设置组织名称
                        String orgName = datas.get(3);
                        detailVO.setOrgName(orgName);
                        //设置组织类型
                    try {
                        Integer orgType;
                        if (Objects.equals(datas.get(4), "集团")){
                            orgType = 1;
                        } else {
                            if (Objects.equals(datas.get(4), "分公司")){
                                orgType = 2;
                            }else{
                                orgType = 3;
                            }
                        }
                        detailVO.setOrgType(orgType);
                    }
                    catch (Exception e) {
                        detailVO.setErrMsg("组织类型错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    //金额大小校验
                    if (detailVO.getProposedInvestmentMny().compareTo(detailVO.getMaxProposedInvestmentMny()) > 0){
                        detailVO.setErrMsg("最小拟投入金额不能大于最大拟投入金额!");
                        errorList.add(detailVO);
                    }
                        //设置备注
                        String memo = datas.get(5);
                        detailVO.setMemo(memo);

                    successList.add(detailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}
