package com.ejianc.business.jltest.orgtest.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.jltest.orgtest.bean.MeetingDetailEntity;
import com.ejianc.business.jltest.orgtest.bean.MeetingEntity;
import com.ejianc.business.jltest.orgtest.service.IMeetingDetailService;
import com.ejianc.business.jltest.orgtest.service.IMeetingService;
import com.ejianc.business.jltest.orgtest.vo.MeetingVO;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/meeting/")
public class MeetingApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMeetingDetailService meetingDetailService;
    @Autowired
    private IMeetingService meetingService;

    /**
     * 根据明细id 获取单据详情
     *
     * @param detailId 明细id
     * @return
     */
    @ApiOperation("根据物资明细id 获取验收单详情")
    @RequestMapping(value = "/queryMeetingByDetailId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MeetingVO> queryMeetingByDetailId(@RequestParam("detailId") Long detailId) {
        logger.info("物资明细id，查询参数：{}", detailId);

        MeetingDetailEntity meetingDetailEntity = meetingDetailService.selectById(detailId);
        MeetingEntity meetingEntity = meetingService.selectById(meetingDetailEntity.getMeetingId());

        logger.info("根据物资明细id 获取验收单详情，查询结果：{}", JSONObject.toJSONString(meetingEntity));
        return CommonResponse.success("查询成功", BeanMapper.map(meetingEntity,MeetingVO.class));
    }


}
