package com.ejianc.business.jltest.margin.bean;

import java.util.ArrayList;
import java.util.Date;
import java.math.*;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.jltest.orgtest.bean.DangercDetailEntity;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 质管部风险金缴纳标准
 *
 * @author generator
 */
@TableName("ejc_jltest_direct_standard")
public class DirectStandardEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "bill_code")
    private String billCode; // 单据编码
    @TableField(value = "org_id")
    private Long orgId; // 组织
    @TableField(value = "org_name")
    private String orgName; // 组织名称
    @TableField(value = "org_code")
    private String orgCode; // 组织code
    @TableField(value = "amount_last")
    private BigDecimal amountLast; // 上一年度完成合同额
    @TableField(value = "amount_goal")  
    private BigDecimal amountGoal; // 本年度完成合同额（指标）
    @TableField(value = "value_last")
    private BigDecimal valueLast; // 上一年度产值
    @TableField(value = "value_goal")
    private BigDecimal valueGoal; // 本年度产值
    @TableField(value = "year")
    private Integer year; // 所属年度
    @TableField(value = "margin_payable")
    private BigDecimal marginPayable; // 风险金应缴纳金额
    @TableField(value = "margin_ratio")
    private BigDecimal marginRatio; // 风险金申请缴纳比例
    @TableField(value = "margin_apply")
    private BigDecimal marginApply; // 风险金申请缴纳金额
    @TableField(value = "employee_id")
    private Long employeeId; // 申请人
    @TableField(value = "employee_name")
    private String employeeName; // 申请人人名称
    @TableField(value = "department_id")
    private Long departmentId; // 申请部门
    @TableField(value = "department_name")
    private String departmentName; // 申请部门名称
    @TableField(value = "apply_date")
    private Date applyDate; //申请日期

    @TableField(value = "change_state")
    private Integer changeState; //变更状态 1-未变更 2-已变更 3-变更中

    @TableField(value = "memo")
    private String memo; // 申请事由
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态（审批必须字段）

    @TableField(exist = false)
    @SubEntity(serviceName = "directStandardDetailService", pidName = "standardId")
    private List<DirectStandardDetailEntity> detailList = new ArrayList<>(); // 计划明细

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public BigDecimal getAmountLast() {
        return amountLast;
    }

    public void setAmountLast(BigDecimal amountLast) {
        this.amountLast = amountLast;
    }

    public BigDecimal getValueLast() {
        return valueLast;
    }

    public void setValueLast(BigDecimal valueLast) {
        this.valueLast = valueLast;
    }

    public BigDecimal getValueGoal() {
        return valueGoal;
    }

    public void setValueGoal(BigDecimal valueGoal) {
        this.valueGoal = valueGoal;
    }

    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public BigDecimal getMarginPayable() {
        return marginPayable;
    }

    public void setMarginPayable(BigDecimal marginPayable) {
        this.marginPayable = marginPayable;
    }

    public BigDecimal getMarginRatio() {
        return marginRatio;
    }

    public void setMarginRatio(BigDecimal marginRatio) {
        this.marginRatio = marginRatio;
    }

    public BigDecimal getMarginApply() {
        return marginApply;
    }

    public void setMarginApply(BigDecimal marginApply) {
        this.marginApply = marginApply;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }

    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }

    public List<DirectStandardDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<DirectStandardDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public BigDecimal getAmountGoal() {
        return amountGoal;
    }

    public void setAmountGoal(BigDecimal amountGoal) {
        this.amountGoal = amountGoal;
    }
}
