package com.ejianc.business.jltest.margin.service.impl;

import com.ejianc.business.jltest.margin.bean.PaymentDetailsEntity;
import com.ejianc.business.jltest.margin.bean.RiskPayConfirmationEntity;
import com.ejianc.business.jltest.margin.service.IPaymentDetailsService;
import com.ejianc.framework.auth.session.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.Map;

// TODO: 2024/3/15 缴纳详情表 b
@Service("paymentDetails")
public class PaymentDetailsBpmServiceImpl implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private PaymentDetailsServiceImpl paymentDetailsService;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private RiskPayConfirmationServiceImpl riskPayConfirmationService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批后回调
     *
     * @param billId       //单据id
     * @param state        //单据状态
     * @param billTypeCode //单据类型code
     * @param taskId       //该流程id
     * @param isEnd        //该节点是否结束
     * @return
     */
    @Override
    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO 向 风险缴纳金确认表 插入数据
        /*
            有无审批流 都会走这里
                有审批流 statue=3
                无审批流 state=1
        */
        logger.info("开始向风险缴纳金确认表 插入数据");
        if (state == 1) {
            //硬性条件   state == 1
            //先查询 风险缴纳金表
            PaymentDetailsEntity pEntity = paymentDetailsService.selectById(billId);
            logger.info("风险缴纳金表 pEntity",pEntity);
            //创建 想要生成的 实体对象
            try {
                RiskPayConfirmationEntity rEntity = new RiskPayConfirmationEntity();
                rEntity.setId(pEntity.getId());//id 数据库中 未设置 主键id自动增长，以防万一。在这里设置id 为pentity的主键id
                rEntity.setApplyPeopleName(sessionManager.getUserContext().getEmployeeName()); //申请人的姓名 默认设置为当前登录人的信息
                rEntity.setApplyForTime(new Date());//设置申请时间
                rEntity.setEmployeeDetailId(pEntity.getEmployeeDetailId());//设置员工明细表的主键
                rEntity.setEmployeeId(pEntity.getEmployeeId());//经办人的id
                rEntity.setEmployeeName(pEntity.getEmployeeName());//经办人姓名
                rEntity.setMemo(pEntity.getMemo());//备注
                rEntity.setBillCode(pEntity.getBillCode());//单据编号
                rEntity.setTenantId(pEntity.getTenantId());//租户id
                rEntity.setIsStaged(pEntity.getIsStaged());//是否分期
                rEntity.setProportion(pEntity.getProportion());//百分比
                rEntity.setPaymentAmountTotal(pEntity.getPaymentAmountTotal());//含本期已缴纳金额
                rEntity.setCurrentPaymentAmount(pEntity.getCurrentPaymentAmount());//本期缴纳金额
                rEntity.setRemainingPaymentAmount(pEntity.getRemainingPaymentAmount());//剩余该缴金额
                riskPayConfirmationService.saveOrUpdate(rEntity,false);

                //更新确认状态
                pEntity.setConfirmationState(0);// -1 待确认   0 确认中   1已确认
                paymentDetailsService.updateById(pEntity);
            } catch (Exception e) {
                logger.error("风险缴纳金确认表 数据插入失败",e);
            }

        }

        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
