package com.ejianc.business.jltest.orgtest.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.jltest.orgtest.bean.PlaneDetailEntity;
/**
 * 安措费使用计划E
 * 
 * @author generator
 * 
 */
 @TableName("ejc_jltest_plane")
public class PlaneEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 计划发文字号
    @TableField(value="plan_name")
    private String planName; // 计划发文名称
    @TableField(value="plan_urgent")
    private String planUrgent; // 紧急程度 0-特急,1-急、2-一般
    @TableField(value="plan_secret")
    private String planSecret; // 密级 0-公开,1-秘密,2-机密
    @TableField(value="plan_date")
    private Date planDate; // 计划发文日期
    @TableField(value="plan_mny")
    private BigDecimal planMny; // 拟投入金额
    @TableField(value="plan_description")
    private String planDescription; // 计划发文说明
    @TableField(value="safeteame_id")
    private Long safeteameId; // 安全小组主键
    @TableField(value="safeteame_name")
    private String safeteameName; // 安全小组名称
    @TableField(value="safeteame_bill_code")
    private String safeteameBillCode; // 安全小组发文字号
    @TableField(value="safeteame_date")
    private Date safeteameDate; // 安全小组成立日期
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目code
    @TableField(value="submit_id")
    private Long submitId; // 提交人
    @TableField(value="submit_name")
    private String submitName; // 提交人姓名
    @TableField(value="submit_date")
    private Date submitDate; // 提交日期
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="planeDetailService",pidName = "planId")
    private List<PlaneDetailEntity> planeDetailList = new ArrayList<>(); // 安措费使用计划E明细
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getPlanName() {
        return planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }
    public String getPlanUrgent() {
        return planUrgent;
    }

    public void setPlanUrgent(String planUrgent) {
        this.planUrgent = planUrgent;
    }
    public String getPlanSecret() {
        return planSecret;
    }

    public void setPlanSecret(String planSecret) {
        this.planSecret = planSecret;
    }
    public Date getPlanDate() {
        return planDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }
    public BigDecimal getPlanMny() {
        return planMny;
    }

    public void setPlanMny(BigDecimal planMny) {
        this.planMny = planMny;
    }
    public String getPlanDescription() {
        return planDescription;
    }

    public void setPlanDescription(String planDescription) {
        this.planDescription = planDescription;
    }
    public Long getSafeteameId() {
        return safeteameId;
    }

    public void setSafeteameId(Long safeteameId) {
        this.safeteameId = safeteameId;
    }
    public String getSafeteameName() {
        return safeteameName;
    }

    public void setSafeteameName(String safeteameName) {
        this.safeteameName = safeteameName;
    }
    public String getSafeteameBillCode() {
        return safeteameBillCode;
    }

    public void setSafeteameBillCode(String safeteameBillCode) {
        this.safeteameBillCode = safeteameBillCode;
    }
    public Date getSafeteameDate() {
        return safeteameDate;
    }

    public void setSafeteameDate(Date safeteameDate) {
        this.safeteameDate = safeteameDate;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getSubmitId() {
        return submitId;
    }

    public void setSubmitId(Long submitId) {
        this.submitId = submitId;
    }
    public String getSubmitName() {
        return submitName;
    }

    public void setSubmitName(String submitName) {
        this.submitName = submitName;
    }
    public Date getSubmitDate() {
        return submitDate;
    }

    public void setSubmitDate(Date submitDate) {
        this.submitDate = submitDate;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    

    public List<PlaneDetailEntity> getPlaneDetailList() {
        return planeDetailList;
    }

    public void setPlaneDetailList(List<PlaneDetailEntity> planeDetailList) {
        this.planeDetailList = planeDetailList;
    }
}
