package com.ejianc.business.jltest.orgtest.controller;

import java.io.Serializable;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jltest.orgtest.bean.*;
import com.ejianc.business.jltest.orgtest.service.IPlaneDetailService;
import com.ejianc.business.jltest.orgtest.service.ISafeteameService;
import com.ejianc.business.jltest.orgtest.vo.*;
import com.ejianc.business.pro.income.utils.TreeNodeBUtil;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.apache.xpath.operations.Bool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jltest.orgtest.service.IPlaneService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 安措费使用计划E
 *
 * @author generator
 */
@Controller
@RequestMapping("plane")
public class PlaneController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PLANE";//此处需要根据实际修改

    @Autowired
    private IPlaneService service;

    @Autowired
    private IPlaneDetailService planeDetailService;

    @Autowired
    private ISafeteameService safeteameService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PlaneVO> saveOrUpdate(@RequestBody PlaneVO saveOrUpdateVO) {
        PlaneEntity entity = BeanMapper.map(saveOrUpdateVO, PlaneEntity.class);


        if ((entity.getId() == null || entity.getId() == 0) && (entity.getBillCode() == null || entity.getBillCode().equals(""))) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //设置被选择的安全小组为引用状态 planFlag=1
        logger.info("设置被选择的安全小组为引用状态 planFlag=1");
        System.out.println("当前小组：" + saveOrUpdateVO.getSafeteameId());
        //构造update条件，根据Id将数据设置为flag=1
        LambdaUpdateWrapper<SafeteameEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(SafeteameEntity::getId, saveOrUpdateVO.getSafeteameId());
        updateWrapper.set(SafeteameEntity::getPlanFlag, 1);
        boolean update = safeteameService.update(updateWrapper);
        if (update) {
            logger.info("成功将当前小组设置为引用状态");
        }

        //根据组织主键  查询当前组织是否存在未生效的单据
        //状态1和3是已生效状态
        List<Integer> list = new ArrayList<>();
        list.add(1);
        list.add(3);
        QueryParam queryParam = new QueryParam();
        //当前组织Id条件
        queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, saveOrUpdateVO.getOrgId()));
        //修改时
        if (entity.getId() != null) {
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, saveOrUpdateVO.getId()));
        }
        //设置条件 单据状态不包括list集合中的数据（1和3）
        queryParam.getParams().put("billState", new Parameter(QueryParam.NOT_IN, list));
        //根据条件查询
        List<PlaneEntity> entityList = service.queryList(queryParam, false);
        //如果查询结果不为空，证明存在未生效的单据
        if (CollectionUtils.isNotEmpty(entityList)) {
            throw new BusinessException("当前组织存在未生效的单据，不允许新增");
        }

        //保存计划
        service.saveOrUpdate(entity, false);


        PlaneVO vo = BeanMapper.map(entity, PlaneVO.class);
        //回写提交人和提交时间
        vo.setSubmitName(sessionManager.getUserContext().getEmployeeName());
        vo.setSubmitId(sessionManager.getUserContext().getEmployeeId());
        vo.setSubmitDate(new Date());
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlaneVO> queryDetail(Long id) {
        System.out.println(id);
        PlaneEntity entity = service.selectById(id);
        PlaneVO vo = BeanMapper.map(entity, PlaneVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlaneVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PlaneVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        //删除时将上游单据状态改为0（未被引用）
        logger.info("删除时将上游单据状态改为0（未被引用）");
        //new一个ids数组
        List<Long> ids = new ArrayList<Long>();
        //遍历PlaneVO获取删除的ids
        for (PlaneVO vo : vos) {
            ids.add(vo.getId());
        }
        logger.info("遍历PlaneVO获取删除的ids");
        //根据Ids查询计划plane
        LambdaQueryWrapper<PlaneEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(PlaneEntity::getId, ids);
        List<PlaneEntity> planeEntities = service.list(wrapper);
        //遍历planeEntities获取safeteameId
        List<Long> safeteameIds = new ArrayList<Long>();
        for (PlaneEntity planeEntity : planeEntities) {
            safeteameIds.add(planeEntity.getSafeteameId());
        }
        //将Id为safeteameIds更新为flag=0
        LambdaUpdateWrapper<SafeteameEntity> safeteameUpdateWrapper = new LambdaUpdateWrapper<>();
        safeteameUpdateWrapper.in(SafeteameEntity::getId, safeteameIds);
        safeteameUpdateWrapper.set(SafeteameEntity::getPlanFlag, 0);
        boolean update = safeteameService.update(safeteameUpdateWrapper);
        if (update) {
            logger.info("成功将上游单据状态改为0（未引用）");
        }
        service.removeByIds(vos.stream().map(PlaneVO::getId).collect(Collectors.toList()), false);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PlaneListVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */


        //筛选条件 经办人为当前登录人
        if (param.getParams().get("employeeId") != null) {
            Boolean isCurrentEmployee = (Boolean) param.getParams().get("employeeId").getValue();
            if (isCurrentEmployee) {
                logger.info("筛选条件:经办人为当前登录人");
                Long employeeId = sessionManager.getUserContext().getEmployeeId();
                param.getParams().put("employeeId", new Parameter(QueryParam.EQ, employeeId));
            } else {
                param.getParams().remove("employeeId");
            }
        }
        IPage<PlaneEntity> page = service.queryPage(param, false);
        IPage<PlaneListVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<PlaneListVO> resDatas = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(page.getRecords())) {
            resDatas = BeanMapper.mapList(page.getRecords(), PlaneListVO.class);
            List<Long> ids = new ArrayList<>();
            Map<Long, Integer> map = new HashMap<>();
            if (CollectionUtils.isNotEmpty(resDatas)) {
                resDatas.forEach(e -> {
                    ids.add(e.getId());
                    map.put(e.getId(), e.getBillState());
                });
            }

            LambdaQueryWrapper<PlaneDetailEntity> lambda = Wrappers.<PlaneDetailEntity>lambdaQuery();
            lambda.in(PlaneDetailEntity::getPlanId, ids);
            List<PlaneDetailEntity> resList = planeDetailService.list(lambda);
            List<PlaneListVO> planeDetailVOList = BeanMapper.mapList(resList, PlaneListVO.class);
            if (CollectionUtils.isNotEmpty(planeDetailVOList)) {
                planeDetailVOList.forEach(e -> {
                    e.setBillState(map.get(e.getPlanId()));
                    e.setPlanMny(e.getDetailMny());
                    e.setPlanName(e.getDetailName());
                });

                resDatas.addAll(planeDetailVOList);
            }
            pageData.setRecords(TreeNodeBUtil.buildTree(resDatas));
            return CommonResponse.success("查询列表数据成功！(tree)", pageData);
        } else {
            pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlaneListVO.class));
            return CommonResponse.success("查询列表数据成功！", pageData);
        }
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        List<PlaneEntity> list = service.queryList(param);
        List<PlaneListVO> resDatas = new ArrayList<>();
        Map<String, Object> beans = new HashMap<>();
        if (CollectionUtils.isNotEmpty(list)) {
            resDatas = BeanMapper.mapList(list, PlaneListVO.class);
            List<Long> ids = new ArrayList<>();
            Map<Long, Integer> map = new HashMap<>();
            if (CollectionUtils.isNotEmpty(resDatas)) {
                resDatas.forEach(e -> {
                    ids.add(e.getId());
                    map.put(e.getId(), e.getBillState());
                });
            }

            LambdaQueryWrapper<PlaneDetailEntity> lambda = Wrappers.<PlaneDetailEntity>lambdaQuery();
            lambda.in(PlaneDetailEntity::getPlanId, ids);
            List<PlaneDetailEntity> resList = planeDetailService.list(lambda);
            List<PlaneListVO> planeDetailVOList = BeanMapper.mapList(resList, PlaneListVO.class);

            if (CollectionUtils.isNotEmpty(planeDetailVOList)) {
                planeDetailVOList.forEach(e -> {
                    System.out.println(e.toString());
//                    e.setBillState(map.get(e.getPlanId()));
//                    e.setPlanName(e.getDetailName());
//                    e.setPlanMny(e.getDetailMny());
//                    e.setPlanName(e.getDetailName());
                });

                resDatas.addAll(planeDetailVOList);
            }
            resDatas = TreeNodeBUtil.buildTree(resDatas);

            beans.put("records", resDatas);
        } else {
            beans.put("records", resDatas);
        }
        ExcelExport.getInstance().export("Plane-export.xlsx", beans, response);
    }


    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPlaneData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PlaneVO>> refPlaneData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                       String condition,
                                                       String searchObject,
                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PlaneEntity> page = service.queryPage(param, false);
        IPage<PlaneVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlaneVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadInfo")
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "MeetingDetail-import.xlsx", "使用计划明细模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<PlaneDetailVO> successList = new ArrayList<>();
        List<PlaneDetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    PlaneDetailVO planeDetailVO = new PlaneDetailVO();
                    planeDetailVO.setId(com.ejianc.support.idworker.util.IdWorker.getId());
                    String detailName = datas.get(0);
                    if (StringUtils.isEmpty(detailName)) {
                        planeDetailVO.setErrorMsg("安全费用项目名称为空");
                        errorList.add(planeDetailVO);
                        continue;
                    } else {
                        planeDetailVO.setDetailName(detailName);
                    }
                    try {
                        String detailMny = datas.get(1);
                        planeDetailVO.setDetailMny(StringUtils.isNotBlank(detailMny) ? new BigDecimal(detailMny) : null);
                    } catch (Exception e) {
                        planeDetailVO.setErrorMsg("最低价格式错误！");
                        errorList.add(planeDetailVO);
                        continue;
                    }
                    try {
                        String detailMaxMny = datas.get(2);
                        planeDetailVO.setDetailMaxMny(new BigDecimal(detailMaxMny));
                    } catch (Exception e) {
                        planeDetailVO.setErrorMsg("最高价格式错误！");
                        errorList.add(planeDetailVO);
                        continue;
                    }
                    // 组织验证
                    String orgName = datas.get(3);
                    CommonResponse<OrgVO> orgResult = iOrgApi.findByNameAndTenantId(orgName, 999999L);
                    if (!orgResult.isSuccess()) {
                        planeDetailVO.setErrorMsg("组织不存在！");
                        errorList.add(planeDetailVO);
                        continue;
                    }
                    OrgVO orgVO = orgResult.getData();
                    if (ObjectUtil.isEmpty(orgVO)) {
                        planeDetailVO.setErrorMsg("组织不存在！");
                        errorList.add(planeDetailVO);
                        continue;
                    }
                    planeDetailVO.setOrgId(orgVO.getId());
                    planeDetailVO.setOrgName(orgVO.getName());
                    String orgType = datas.get(4);
                    if (orgType.equals("集团")) {
                        planeDetailVO.setOrgType(1);
                    } else if (orgType.equals("分公司")) {
                        planeDetailVO.setOrgType(2);
                    } else if (orgType.equals("项目部")) {
                        planeDetailVO.setOrgType(3);
                    } else {
                        planeDetailVO.setErrorMsg("组织类型不存在" + orgType + "！");
                        errorList.add(planeDetailVO);
                        continue;
                    }


                    String detailDescription = datas.get(5);
                    if (StringUtils.isEmpty(detailDescription)) {
                        planeDetailVO.setErrorMsg("备注为空");
                        errorList.add(planeDetailVO);
                        continue;
                    } else {
                        planeDetailVO.setDetailDescription(detailDescription);
                    }

                    successList.add(planeDetailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}
