package com.ejianc.business.jltest.orgtest.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jltest.orgtest.bean.SafeTeamaEntity;
import com.ejianc.business.jltest.orgtest.service.ISafeTeamaService;
import com.ejianc.business.jltest.orgtest.vo.MeetingVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jltest.orgtest.mapper.MeetingMapper;
import com.ejianc.business.jltest.orgtest.bean.MeetingEntity;
import com.ejianc.business.jltest.orgtest.service.IMeetingService;

import java.util.ArrayList;
import java.util.List;

/**
 * 安全生成会议
 * 
 * @author generator
 * 
 */
@Service("meetingService")
public class MeetingServiceImpl extends BaseServiceImpl<MeetingMapper, MeetingEntity> implements IMeetingService{
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private ISafeTeamaService safeTeamaService;

    private static final String BILL_CODE = "MEETING_CODE";//此处需要根据实际修改
    @Override
    public MeetingVO saveUpdate(MeetingVO saveOrUpdateVO) {
        MeetingEntity entity = BeanMapper.map(saveOrUpdateVO, MeetingEntity.class);


        //todo 根据前端传来的组织主键  查询是否存在未生效的单据
//        List<Integer> list = new ArrayList<>();
//        list.add(1);
//        list.add(3);
//        QueryParam queryParam = new QueryParam();
//        queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, saveOrUpdateVO.getOrgId()));
//        if(entity.getId() != null){
//            queryParam.getParams().put("id", new Parameter(QueryParam.NE, saveOrUpdateVO.getId()));
//        }
//        queryParam.getParams().put("billState", new Parameter(QueryParam.NOT_IN, list));
//        List<MeetingEntity> entityList = super.queryList(queryParam, false);
//        if(CollectionUtils.isNotEmpty(entityList)){
//            throw new BusinessException("当前组织存在未生效的单据，不允许新增");
//        }

        LambdaQueryWrapper<MeetingEntity> lambda = Wrappers.<MeetingEntity>lambdaQuery();
        lambda.eq(MeetingEntity::getOrgId, saveOrUpdateVO.getOrgId());
        if(entity.getId() != null){
            lambda.ne(MeetingEntity::getId, saveOrUpdateVO.getId());
        }
        lambda.notIn(MeetingEntity::getBillState, 1,3);
        List<MeetingEntity> entityList2 =super.list(lambda);
        if(CollectionUtils.isNotEmpty(entityList2)){
            throw new BusinessException("当前组织存在未生效的单据，不允许新增");
        }


        if((entity.getId() == null || entity.getId() == 0)&&StringUtils.isEmpty(entity.getBillCode())){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }



        super.saveOrUpdate(entity, false);


        //todo  回写上游单据 引用状态

//        SafeTeamaEntity safeTeamaEntity = safeTeamaService.selectById(saveOrUpdateVO.getSafeteamaId());
//        safeTeamaEntity.setMeetingFlag(2);
//        safeTeamaService.updateById(safeTeamaEntity)

        LambdaUpdateWrapper<SafeTeamaEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(SafeTeamaEntity::getId, saveOrUpdateVO.getSafeteamaId());
        updateWrapper.set(SafeTeamaEntity::getMeetingFlag,2);
        safeTeamaService.update(updateWrapper);


        MeetingVO vo = BeanMapper.map(entity, MeetingVO.class);
        return vo;
    }
}
