package com.ejianc.business.jltest.orgtest.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.jltest.orgtest.bean.PlanaEntity;
import com.ejianc.business.jltest.orgtest.bean.SafeTeamaEntity;
import com.ejianc.business.jltest.orgtest.mapper.PlanaMapper;
import com.ejianc.business.jltest.orgtest.service.IPlanaService;
import com.ejianc.business.jltest.orgtest.service.ISafeTeamaService;
import com.ejianc.business.jltest.orgtest.vo.PlanaVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 安措费使用计划A
 * 
 * @author generator
 * 
 */
@Service("planaService")
public class PlanaServiceImpl extends BaseServiceImpl<PlanaMapper, PlanaEntity> implements IPlanaService{

    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "PLAN_CODE";//此处需要根据实际修改
    @Autowired
    private ISafeTeamaService safeTeamaService;
    @Override
    public PlanaVO saveUpdate(PlanaVO saveOrUpdateVO) {
        PlanaEntity entity = BeanMapper.map(saveOrUpdateVO, PlanaEntity.class);
        //查询是否存在未生效的单子
        LambdaQueryWrapper<PlanaEntity> lambdaQueryWrapper = new LambdaQueryWrapper<PlanaEntity>();
        //组织相同
        lambdaQueryWrapper.eq(PlanaEntity::getOrgId,saveOrUpdateVO.getOrgId());
        //修改的情况下 去除本身
        if (entity.getId()!=null){
            lambdaQueryWrapper.ne(PlanaEntity::getId,saveOrUpdateVO.getId());
        }
        //上游订单状态  不是 1或3
        lambdaQueryWrapper.notIn(PlanaEntity::getBillState,1,3);
        //查询是否有数据，有数据不允许新增
        List<PlanaEntity> listByBillState = super.list(lambdaQueryWrapper);
        if (CollectionUtils.isNotEmpty(listByBillState)){
            throw new BusinessException("当前组织存在未生效的数据，不允许新增");
        }

        if((entity.getId() == null || entity.getId() == 0)&& StringUtils.isEmpty(entity.getBillCode())){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);

        //新增后将上有组织状态该为2
        LambdaUpdateWrapper<SafeTeamaEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(SafeTeamaEntity::getId,saveOrUpdateVO.getSafeteamaId());
        updateWrapper.set(SafeTeamaEntity::getMeetingFlag,2);
        safeTeamaService.update(updateWrapper);
        PlanaVO vo = BeanMapper.map(entity, PlanaVO.class);
        return vo;
    }

    @Override
    public void removeByIdsRewrite(List<PlanaVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
//            for (PlanaVO vo : vos) {
//                // 参数是单据类型编码字符串 根据需求是否打开下面代码
//                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
//                if(!resp.isSuccess()){
//                    return CommonResponse.error("删除失败！"+resp.getMsg());
//                }*/
//            }
            //删除前将上游单据状态改为1
            //获取批量删除单据的id
            List<Long> ids = vos.stream().map(PlanaVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper<PlanaEntity> queryWrapper = new LambdaQueryWrapper<>();
            //查询id存在ids的数据
            queryWrapper.in(PlanaEntity::getId,ids);
            List<PlanaEntity> planaEntities = super.list(queryWrapper);
            //获取上游数据的id
            List<Long> safeteamaIds = planaEntities.stream().map(PlanaEntity::getSafeteamaId).collect(Collectors.toList());
            //修改上游数据
            LambdaUpdateWrapper<SafeTeamaEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(SafeTeamaEntity::getId,safeteamaIds);
            updateWrapper.set(SafeTeamaEntity::getMeetingFlag,1);
            safeTeamaService.update(updateWrapper);


        }
        super.removeByIds(vos.stream().map(PlanaVO::getId).collect(Collectors.toList()),true);
    }
}
