package com.ejianc.business.jltest.orgtest.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jltest.orgtest.bean.*;
import com.ejianc.business.jltest.orgtest.service.ISafeTeamaService;
import com.ejianc.business.jltest.orgtest.service.ISafeteambService;
import com.ejianc.business.jltest.orgtest.vo.MeetingVO;
import com.ejianc.business.jltest.orgtest.vo.PlanaVO;
import com.ejianc.business.jltest.orgtest.vo.PlanbVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jltest.orgtest.mapper.PlanbMapper;
import com.ejianc.business.jltest.orgtest.service.IPlanbService;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

/**
 * 安措费使用计划B
 * 
 * @author generator
 * 
 */
@Service("planbService")
public class PlanbServiceImpl extends BaseServiceImpl<PlanbMapper, PlanbEntity> implements IPlanbService{


    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private ISafeteambService safeteambService;
    private static final String BILL_CODE = "PLAN-B";//此处需要根据实际修改

    @Override
    public PlanbVO saveUpdate(PlanbVO saveOrUpdateVO) {
        PlanbEntity entity = BeanMapper.map(saveOrUpdateVO, PlanbEntity.class);

        if(StringUtils.isEmpty(entity.getBillCode())){
            entity.setBillCode(BILL_CODE+ UUID.randomUUID().toString().replace("-","").substring(1,6));
        }
        //todo 根据前端传来的组织主键  查询是否存在未生效的单据
//        List<Integer> list = new ArrayList<>();
//        list.add(1);
//        list.add(3);
//        QueryParam queryParam = new QueryParam();
//        queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, saveOrUpdateVO.getOrgId()));
//        if(entity.getId() != null){
//            queryParam.getParams().put("id", new Parameter(QueryParam.NE, saveOrUpdateVO.getId()));
//        }
//        queryParam.getParams().put("billState", new Parameter(QueryParam.NOT_IN, list));
//        List<MeetingEntity> entityList = super.queryList(queryParam, false);
//        if(CollectionUtils.isNotEmpty(entityList)){
//            throw new BusinessException("当前组织存在未生效的单据，不允许新增");
//        }

        LambdaQueryWrapper<PlanbEntity> lambda = Wrappers.<PlanbEntity>lambdaQuery();
        lambda.eq(PlanbEntity::getOrgId, saveOrUpdateVO.getOrgId());
        if(entity.getId() != null){
            lambda.ne(PlanbEntity::getId, saveOrUpdateVO.getId());
        }

        // 1 3 的状态 分别是 已提交  审核通过
        lambda.notIn(PlanbEntity::getBillState, 1,3);

        List<PlanbEntity> entityList2 =super.list(lambda);
        if(CollectionUtils.isNotEmpty(entityList2)){
            throw new BusinessException("当前组织存在未生效的单据，不允许新增");
        }


        if((entity.getId() == null || entity.getId() == 0)&& StringUtils.isEmpty(entity.getBillCode())){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }



        super.saveOrUpdate(entity, false);


        //todo  回写上游单据 引用状态

//        SafeTeamaEntity safeTeamaEntity = safeTeamaService.selectById(saveOrUpdateVO.getSafeteamaId());
//        safeTeamaEntity.setMeetingFlag(2);
//        safeTeamaService.updateById(safeTeamaEntity)

        LambdaUpdateWrapper<SafeteambEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(SafeteambEntity::getId, saveOrUpdateVO.getSafeteambId());
        updateWrapper.set(SafeteambEntity::getMeetingFlag,2);
        safeteambService.update(updateWrapper);


        PlanbVO vo = BeanMapper.map(entity, PlanbVO.class);
        return vo;
    }

    @Override
    public void removeByIdsRewrite(List<PlanbVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            //删除前将上游单据状态改为1
            //获取批量删除单据的id
            List<Long> ids = vos.stream().map(PlanbVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper<PlanbEntity> queryWrapper = new LambdaQueryWrapper<>();
            //查询id存在ids的数据
            queryWrapper.in(PlanbEntity::getId,ids);
            List<PlanbEntity> planaEntities = super.list(queryWrapper);
            //获取上游数据的id
            List<Long> safeteamaIds = planaEntities.stream().map(PlanbEntity::getSafeteambId).collect(Collectors.toList());
            //修改上游数据
            LambdaUpdateWrapper<SafeteambEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(SafeteambEntity::getId,safeteamaIds);
            updateWrapper.set(SafeteambEntity::getMeetingFlag,1);
            safeteambService.update(updateWrapper);


        }
        super.removeByIds(vos.stream().map(PlanbVO::getId).collect(Collectors.toList()),true);
    }
}
