/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jltest.orgtest.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jltest.orgtest.bean.PlanaDetailEntity;
import com.ejianc.business.jltest.orgtest.bean.PlanaEntity;
import com.ejianc.business.jltest.orgtest.service.IPlanaDetailService;
import com.ejianc.business.jltest.orgtest.service.IPlanaService;
import com.ejianc.business.jltest.orgtest.vo.PlanaDetailVO;
import com.ejianc.business.jltest.orgtest.vo.PlanaListVO;
import com.ejianc.business.jltest.orgtest.vo.PlanaVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"plana"})
public class PlanaController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PLAN_CODE";
    @Autowired
    private IPlanaService service;
    @Autowired
    private IPlanaDetailService planaDetailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PlanaVO> saveOrUpdate(@RequestBody PlanaVO saveOrUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveUpdate(saveOrUpdateVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PlanaVO> queryDetail(Long id) {
        PlanaEntity entity = (PlanaEntity)((Object)this.service.selectById(id));
        PlanaVO vo = (PlanaVO)BeanMapper.map((Object)((Object)entity), PlanaVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlanaVO> vos) {
        this.service.removeByIdsRewrite(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PlanaListVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("org_id");
        fuzzyFields.add("employee_name");
        fuzzyFields.add("plana_name");
        if (param.getParams().get("employeeId") != null) {
            System.out.println("\u5224\u65ad\u662f\u5426\u4e3a\u5f53\u524d\u767b\u9646\u4eba" + ((Parameter)param.getParams().get("employeeId")).getValue());
            if (((Parameter)param.getParams().get("employeeId")).getValue().toString().equals("true")) {
                Long employeeId = this.sessionManager.getUserContext().getEmployeeId();
                param.getParams().put("employeeId", new Parameter("eq", (Object)employeeId));
            } else {
                param.getParams().remove("employeeId");
            }
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List resDatas = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            resDatas = BeanMapper.mapList((Iterable)page.getRecords(), PlanaListVO.class);
            ArrayList ids = new ArrayList();
            HashMap map = new HashMap();
            if (CollectionUtils.isNotEmpty(resDatas)) {
                resDatas.forEach(e -> {
                    ids.add(e.getId());
                    map.put(e.getId(), e.getBillState());
                });
            }
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.in(PlanaDetailEntity::getPlanaId, ids);
            List resList = this.planaDetailService.list((Wrapper)lambda);
            List planaListVOList = BeanMapper.mapList((Iterable)resList, PlanaListVO.class);
            if (CollectionUtils.isNotEmpty((Collection)planaListVOList)) {
                planaListVOList.forEach(e -> {
                    e.setBillState((Integer)map.get(e.getPlanaId()));
                    e.setPlanaMny(e.getDetailMny());
                    this.logger.info("\u660e\u7ec6\u8868id\uff1a" + e.getId() + "PlanId\uff1a" + e.getPlanaId() + "orgName" + e.getOrgName() + "billState" + e.getBillState() + "planaMny" + e.getPlanaMny() + "detailMny" + e.getDetailMny());
                });
                resDatas.addAll(planaListVOList);
            }
        }
        pageData.setRecords(TreeNodeBUtil.buildTree(resDatas));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("org_id");
        fuzzyFields.add("employee_name");
        fuzzyFields.add("plana_name");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (param.getParams().get("employeeId") != null) {
            System.out.println("\u5224\u65ad\u662f\u5426\u4e3a\u5f53\u524d\u767b\u9646\u4eba" + ((Parameter)param.getParams().get("employeeId")).getValue());
            if (((Parameter)param.getParams().get("employeeId")).getValue().toString().equals("true")) {
                Long employeeId = this.sessionManager.getUserContext().getEmployeeId();
                param.getParams().put("employeeId", new Parameter("eq", (Object)employeeId));
            } else {
                param.getParams().remove("employeeId");
            }
        }
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List planaListVOS = BeanMapper.mapList((Iterable)list, PlanaListVO.class);
        ArrayList<PlanaListVO> resDatas = new ArrayList<PlanaListVO>();
        for (PlanaListVO p : planaListVOS) {
            switch (p.getPlanaUrgency()) {
                case 1: {
                    p.setUrgencyName("\u7279\u6025");
                    break;
                }
                case 2: {
                    p.setUrgencyName("\u6025");
                    break;
                }
                case 3: {
                    p.setUrgencyName("\u4e00\u822c");
                }
            }
            switch (p.getPlanaSecret()) {
                case 1: {
                    p.setUrgencyName("\u516c\u5f00");
                    break;
                }
                case 2: {
                    p.setUrgencyName("\u79d8\u5bc6");
                    break;
                }
                case 3: {
                    p.setUrgencyName("\u673a\u5bc6");
                    break;
                }
                case 4: {
                    p.setUrgencyName("\u7edd\u5bc6");
                }
            }
            this.logger.info("\u660e\u7ec6\u8868id\uff1a" + p.getId() + "PlanId\uff1a" + p.getPlanaId() + "orgName" + p.getOrgName() + "billState" + p.getBillState() + "planaMny" + p.getPlanaMny() + "detailMny" + p.getDetailMny());
            resDatas.add(p);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"plana_id", (Object)p.getId());
            List list1 = this.planaDetailService.list((Wrapper)queryWrapper);
            List detailList = BeanMapper.mapList((Iterable)list1, PlanaListVO.class);
            if (!CollectionUtils.isNotEmpty((Collection)detailList)) continue;
            for (PlanaListVO detail : detailList) {
                detail.setPlanaMny(detail.getDetailMny());
                this.logger.info("\u660e\u7ec6\u8868id\uff1a" + detail.getId() + "PlanId\uff1a" + detail.getPlanaId() + "orgName" + detail.getOrgName() + "billState" + detail.getBillState() + "planaMny" + detail.getPlanaMny() + "detailMny" + detail.getDetailMny());
                resDatas.add(detail);
            }
        }
        HashMap<String, ArrayList<PlanaListVO>> beans = new HashMap<String, ArrayList<PlanaListVO>>();
        beans.put("records", resDatas);
        ExcelExport.getInstance().export("Plana-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPlanaData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PlanaVO>> refPlanaData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PlanaVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/downloadInfo"})
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"PlanaDetail-import.xlsx", (String)"\u5b89\u63aa\u8d39\u8ba1\u5212A\u660e\u7ec6\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<PlanaDetailVO> successList = new ArrayList<PlanaDetailVO>();
        ArrayList<PlanaDetailVO> errorList = new ArrayList<PlanaDetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                PlanaDetailVO detailVO;
                block19: {
                    String detailMny;
                    List datas = (List)result.get(i);
                    detailVO = new PlanaDetailVO();
                    detailVO.setId(Long.valueOf(IdWorker.getId()));
                    String dtailName = (String)datas.get(0);
                    detailVO.setDetailName(dtailName);
                    try {
                        detailMny = (String)datas.get(1);
                        detailVO.setDetailMny(StringUtils.isNotBlank((CharSequence)detailMny) ? new BigDecimal(detailMny) : null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("\u62df\u6295\u5165\u91d1\u989d\u683c\u5f0f\u9519\u8bef\uff01");
                        errorList.add(detailVO);
                        continue;
                    }
                    try {
                        String detailMaxMny = (String)datas.get(2);
                        detailVO.setDetailMaxMny(StringUtils.isNotBlank((CharSequence)detailMaxMny) ? new BigDecimal(detailMaxMny) : null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("\u6700\u9ad8\u4ef7\u683c\u5f0f\u9519\u8bef\uff01");
                        errorList.add(detailVO);
                        continue;
                    }
                    try {
                        detailMny = (String)datas.get(1);
                        String detailMaxMny = (String)datas.get(2);
                        BigDecimal bigDecimal = new BigDecimal(detailMaxMny);
                        BigDecimal bigDecimal2 = new BigDecimal(detailMny);
                        if (bigDecimal.doubleValue() < bigDecimal2.doubleValue()) {
                            throw new Exception("\u6700\u9ad8\u4ef7\u683c\u5c0f\u4e8e\u6700\u4f4e\u4ef7\uff01");
                        }
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("\u6700\u9ad8\u4ef7\u683c\u5c0f\u4e8e\u6700\u4f4e\u4ef7\uff01");
                        errorList.add(detailVO);
                        continue;
                    }
                    try {
                        String orgName = (String)datas.get(3);
                        CommonResponse byNameAndTenantId = this.iOrgApi.findByNameAndTenantId(orgName, InvocationInfoProxy.getTenantid());
                        if (ObjectUtils.isEmpty((Object)byNameAndTenantId)) {
                            throw new Exception("\u6ca1\u6709\u6b64\u7ec4\u7ec7\uff01");
                        }
                        detailVO.setOrgName(orgName);
                        detailVO.setOrgId(((OrgVO)byNameAndTenantId.getData()).getId());
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("\u6ca1\u6709\u6b64\u7ec4\u7ec7\uff01");
                        errorList.add(detailVO);
                        continue;
                    }
                    try {
                        String orgType = (String)datas.get(4);
                        if (orgType.equals("\u96c6\u56e2")) {
                            detailVO.setOrgType(Integer.valueOf(1));
                            break block19;
                        }
                        if (orgType.equals("\u5206\u516c\u53f8")) {
                            detailVO.setOrgType(Integer.valueOf(2));
                            break block19;
                        }
                        if (orgType.equals("\u9879\u76ee\u90e8")) {
                            detailVO.setOrgType(Integer.valueOf(3));
                            break block19;
                        }
                        throw new Exception("\u6ca1\u6709\u6b64\u96c6\u56e2\uff01");
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("\u6ca1\u6709\u6b64\u96c6\u56e2\uff01");
                        errorList.add(detailVO);
                        continue;
                    }
                }
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

