/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jltest.orgtest.controller;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jltest.orgtest.bean.PlaneDetailEntity;
import com.ejianc.business.jltest.orgtest.bean.PlaneEntity;
import com.ejianc.business.jltest.orgtest.bean.SafeteameEntity;
import com.ejianc.business.jltest.orgtest.service.IPlaneDetailService;
import com.ejianc.business.jltest.orgtest.service.IPlaneService;
import com.ejianc.business.jltest.orgtest.service.ISafeteameService;
import com.ejianc.business.jltest.orgtest.vo.PlaneDetailVO;
import com.ejianc.business.jltest.orgtest.vo.PlaneListVO;
import com.ejianc.business.jltest.orgtest.vo.PlaneVO;
import com.ejianc.business.pro.income.utils.TreeNodeBUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"plane"})
public class PlaneController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PLANE";
    @Autowired
    private IPlaneService service;
    @Autowired
    private IPlaneDetailService planeDetailService;
    @Autowired
    private ISafeteameService safeteameService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PlaneVO> saveOrUpdate(@RequestBody PlaneVO saveOrUpdateVO) {
        PlaneEntity entity = (PlaneEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PlaneEntity.class));
        if (!(entity.getId() != null && entity.getId() != 0L || entity.getBillCode() != null && !entity.getBillCode().equals(""))) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.logger.info("\u8bbe\u7f6e\u88ab\u9009\u62e9\u7684\u5b89\u5168\u5c0f\u7ec4\u4e3a\u5f15\u7528\u72b6\u6001 planFlag=1");
        System.out.println("\u5f53\u524d\u5c0f\u7ec4\uff1a" + saveOrUpdateVO.getSafeteameId());
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)saveOrUpdateVO.getSafeteameId());
        updateWrapper.set(SafeteameEntity::getPlanFlag, (Object)1);
        boolean update = this.safeteameService.update((Wrapper)updateWrapper);
        if (update) {
            this.logger.info("\u6210\u529f\u5c06\u5f53\u524d\u5c0f\u7ec4\u8bbe\u7f6e\u4e3a\u5f15\u7528\u72b6\u6001");
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(3);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orgId", new Parameter("eq", (Object)saveOrUpdateVO.getOrgId()));
        if (entity.getId() != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)saveOrUpdateVO.getId()));
        }
        queryParam.getParams().put("billState", new Parameter("not_in", list));
        List entityList = this.service.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            throw new BusinessException("\u5f53\u524d\u7ec4\u7ec7\u5b58\u5728\u672a\u751f\u6548\u7684\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e");
        }
        this.service.saveOrUpdate((Object)entity, false);
        PlaneVO vo = (PlaneVO)BeanMapper.map((Object)((Object)entity), PlaneVO.class);
        vo.setSubmitName(this.sessionManager.getUserContext().getEmployeeName());
        vo.setSubmitId(this.sessionManager.getUserContext().getEmployeeId());
        vo.setSubmitDate(new Date());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PlaneVO> queryDetail(Long id) {
        System.out.println(id);
        PlaneEntity entity = (PlaneEntity)((Object)this.service.selectById(id));
        PlaneVO vo = (PlaneVO)BeanMapper.map((Object)((Object)entity), PlaneVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlaneVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PlaneVO object : vos) {
            }
        }
        this.logger.info("\u5220\u9664\u65f6\u5c06\u4e0a\u6e38\u5355\u636e\u72b6\u6001\u6539\u4e3a0\uff08\u672a\u88ab\u5f15\u7528\uff09");
        ArrayList<Long> ids = new ArrayList<Long>();
        for (PlaneVO vo : vos) {
            ids.add(vo.getId());
        }
        this.logger.info("\u904d\u5386PlaneVO\u83b7\u53d6\u5220\u9664\u7684ids");
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(BaseEntity::getId, ids);
        List planeEntities = this.service.list((Wrapper)lambdaQueryWrapper);
        ArrayList<Long> safeteameIds = new ArrayList<Long>();
        for (PlaneEntity planeEntity : planeEntities) {
            safeteameIds.add(planeEntity.getSafeteameId());
        }
        LambdaUpdateWrapper safeteameUpdateWrapper = new LambdaUpdateWrapper();
        safeteameUpdateWrapper.in(BaseEntity::getId, safeteameIds);
        safeteameUpdateWrapper.set(SafeteameEntity::getPlanFlag, (Object)0);
        boolean update = this.safeteameService.update((Wrapper)safeteameUpdateWrapper);
        if (update) {
            this.logger.info("\u6210\u529f\u5c06\u4e0a\u6e38\u5355\u636e\u72b6\u6001\u6539\u4e3a0\uff08\u672a\u5f15\u7528\uff09");
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PlaneListVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        if (param.getParams().get("employeeId") != null) {
            Boolean isCurrentEmployee = (Boolean)((Parameter)param.getParams().get("employeeId")).getValue();
            if (isCurrentEmployee.booleanValue()) {
                this.logger.info("\u7b5b\u9009\u6761\u4ef6:\u7ecf\u529e\u4eba\u4e3a\u5f53\u524d\u767b\u5f55\u4eba");
                Long employeeId = this.sessionManager.getUserContext().getEmployeeId();
                param.getParams().put("employeeId", new Parameter("eq", (Object)employeeId));
            } else {
                param.getParams().remove("employeeId");
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List resDatas = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            resDatas = BeanMapper.mapList((Iterable)page.getRecords(), PlaneListVO.class);
            ArrayList ids = new ArrayList();
            HashMap map = new HashMap();
            if (CollectionUtils.isNotEmpty(resDatas)) {
                resDatas.forEach(e -> {
                    ids.add(e.getId());
                    map.put(e.getId(), e.getBillState());
                });
            }
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.in(PlaneDetailEntity::getPlanId, ids);
            List resList = this.planeDetailService.list((Wrapper)lambda);
            List planeDetailVOList = BeanMapper.mapList((Iterable)resList, PlaneListVO.class);
            if (CollectionUtils.isNotEmpty((Collection)planeDetailVOList)) {
                planeDetailVOList.forEach(e -> {
                    e.setBillState((Integer)map.get(e.getPlanId()));
                    e.setPlanMny(e.getDetailMny());
                    e.setPlanName(e.getDetailName());
                });
                resDatas.addAll(planeDetailVOList);
            }
            pageData.setRecords(TreeNodeBUtil.buildTree(resDatas));
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01(tree)", (Object)pageData);
        }
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PlaneListVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List resDatas = new ArrayList();
        HashMap beans = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resDatas = BeanMapper.mapList((Iterable)list, PlaneListVO.class);
            ArrayList ids = new ArrayList();
            HashMap map = new HashMap();
            if (CollectionUtils.isNotEmpty(resDatas)) {
                resDatas.forEach(e -> {
                    ids.add(e.getId());
                    map.put(e.getId(), e.getBillState());
                });
            }
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.in(PlaneDetailEntity::getPlanId, ids);
            List resList = this.planeDetailService.list((Wrapper)lambda);
            List planeDetailVOList = BeanMapper.mapList((Iterable)resList, PlaneListVO.class);
            if (CollectionUtils.isNotEmpty((Collection)planeDetailVOList)) {
                planeDetailVOList.forEach(e -> System.out.println(e.toString()));
                resDatas.addAll(planeDetailVOList);
            }
            resDatas = TreeNodeBUtil.buildTree(resDatas);
            beans.put("records", resDatas);
        } else {
            beans.put("records", resDatas);
        }
        ExcelExport.getInstance().export("Plane-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPlaneData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PlaneVO>> refPlaneData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PlaneVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/downloadInfo"})
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"MeetingDetail-import.xlsx", (String)"\u4f7f\u7528\u8ba1\u5212\u660e\u7ec6\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<PlaneDetailVO> successList = new ArrayList<PlaneDetailVO>();
        ArrayList<PlaneDetailVO> errorList = new ArrayList<PlaneDetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                PlaneDetailVO planeDetailVO = new PlaneDetailVO();
                planeDetailVO.setId(Long.valueOf(IdWorker.getId()));
                String detailName = (String)datas.get(0);
                if (StringUtils.isEmpty((CharSequence)detailName)) {
                    planeDetailVO.setErrorMsg("\u5b89\u5168\u8d39\u7528\u9879\u76ee\u540d\u79f0\u4e3a\u7a7a");
                    errorList.add(planeDetailVO);
                    continue;
                }
                planeDetailVO.setDetailName(detailName);
                try {
                    String detailMny = (String)datas.get(1);
                    planeDetailVO.setDetailMny(StringUtils.isNotBlank((CharSequence)detailMny) ? new BigDecimal(detailMny) : null);
                }
                catch (Exception e) {
                    planeDetailVO.setErrorMsg("\u6700\u4f4e\u4ef7\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(planeDetailVO);
                    continue;
                }
                try {
                    String detailMaxMny = (String)datas.get(2);
                    planeDetailVO.setDetailMaxMny(new BigDecimal(detailMaxMny));
                }
                catch (Exception e) {
                    planeDetailVO.setErrorMsg("\u6700\u9ad8\u4ef7\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(planeDetailVO);
                    continue;
                }
                String orgName = (String)datas.get(3);
                CommonResponse orgResult = this.iOrgApi.findByNameAndTenantId(orgName, Long.valueOf(999999L));
                if (!orgResult.isSuccess()) {
                    planeDetailVO.setErrorMsg("\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff01");
                    errorList.add(planeDetailVO);
                    continue;
                }
                OrgVO orgVO = (OrgVO)orgResult.getData();
                if (ObjectUtil.isEmpty((Object)orgVO)) {
                    planeDetailVO.setErrorMsg("\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff01");
                    errorList.add(planeDetailVO);
                    continue;
                }
                planeDetailVO.setOrgId(orgVO.getId());
                planeDetailVO.setOrgName(orgVO.getName());
                String orgType = (String)datas.get(4);
                if (orgType.equals("\u96c6\u56e2")) {
                    planeDetailVO.setOrgType(Integer.valueOf(1));
                } else if (orgType.equals("\u5206\u516c\u53f8")) {
                    planeDetailVO.setOrgType(Integer.valueOf(2));
                } else if (orgType.equals("\u9879\u76ee\u90e8")) {
                    planeDetailVO.setOrgType(Integer.valueOf(3));
                } else {
                    planeDetailVO.setErrorMsg("\u7ec4\u7ec7\u7c7b\u578b\u4e0d\u5b58\u5728" + orgType + "\uff01");
                    errorList.add(planeDetailVO);
                    continue;
                }
                String detailDescription = (String)datas.get(5);
                if (StringUtils.isEmpty((CharSequence)detailDescription)) {
                    planeDetailVO.setErrorMsg("\u5907\u6ce8\u4e3a\u7a7a");
                    errorList.add(planeDetailVO);
                    continue;
                }
                planeDetailVO.setDetailDescription(detailDescription);
                successList.add(planeDetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

