package com.ejianc.business.jltest.margin.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.jltest.margin.vo.PaymentDetailsVO;
import com.ejianc.business.jltest.orgtest.bean.PlaneDetailEntity;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 人员缴纳总台账
 *
 * @author generator
 */
@TableName("ejc_jltest_employee_bill")
public class EmployeeBillEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "bill_code")
    private String billCode; // billcode
    @TableField(value = "phone")
    private String phone; // 联系方式
    @TableField(value = "paid_mny")
    private BigDecimal paidMny; // 累计缴纳金额
    @TableField(value = "refund_mny")
    private BigDecimal refundMny; // 累计退还金额
    @TableField(value = "actual_paid_mny")
    private BigDecimal actualPaidMny; // 实际缴纳金额
    @TableField(value = "allotment_mny")
    private BigDecimal allotmentMny; // 累计分配金额
    @TableField(value = "org_id")
    private Long orgId; // 组织
    @TableField(value = "org_name")
    private String orgName; // 组织名称
    @TableField(value = "org_code")
    private String orgCode; // 组织编码
    @TableField(value = "parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value = "parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value = "parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value = "employee_id")
    private Long employeeId; // 经办人
    @TableField(value = "employee_name")
    private String employeeName; // 经办人名称
    @TableField(value = "department_id")
    private Long departmentId; // 经办部门
    @TableField(value = "department_name")
    private String departmentName; // 经办部门名称
    @TableField(value = "project_id")
    private Long projectId; // 项目
    @TableField(value = "project_name")
    private String projectName; // 项目名称
    @TableField(value = "project_code")
    private String projectCode; // 项目code
    @TableField(value = "memo")
    private String memo; // 备注
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(exist = false)
    private List<PaymentDetailsVO> paymentDetailsList = new ArrayList<>(); // 风险金缴纳记录


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public BigDecimal getPaidMny() {
        return paidMny;
    }

    public void setPaidMny(BigDecimal paidMny) {
        this.paidMny = paidMny;
    }

    public BigDecimal getRefundMny() {
        return refundMny;
    }

    public void setRefundMny(BigDecimal refundMny) {
        this.refundMny = refundMny;
    }

    public BigDecimal getActualPaidMny() {
        return actualPaidMny;
    }

    public void setActualPaidMny(BigDecimal actualPaidMny) {
        this.actualPaidMny = actualPaidMny;
    }

    public BigDecimal getAllotmentMny() {
        return allotmentMny;
    }

    public void setAllotmentMny(BigDecimal allotmentMny) {
        this.allotmentMny = allotmentMny;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<PaymentDetailsVO> getPaymentDetailsList() {
        return paymentDetailsList;
    }

    public void setPaymentDetailsList(List<PaymentDetailsVO> paymentDetailsList) {
        this.paymentDetailsList = paymentDetailsList;
    }
}
