package com.ejianc.business.jltest.margin.bean;

import java.sql.Timestamp;
import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import cn.hutool.core.date.DateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 风险金退还
 * 
 * @author generator
 * 
 */
 @TableName("ejc_jltest_risk_money_refund")
public class MoneyRefundEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="employee_schedules_id")
    private Long employeeSchedulesId; // 员工明细表id
    @TableField(value="employee_schedules_name")
    private String employeeSchedulesName; // 员工明细表名称
    @TableField(value="employee_schedules_code")
    private String employeeSchedulesCode; // 员工明细billCode
    @TableField(value="due")
    private BigDecimal due; // 应缴纳金额
    @TableField(value="actual_due")
    private BigDecimal actualDue; // 实际已缴纳金额
    @TableField(value="cumulative_due")
    private BigDecimal cumulativeDue; // 累计已缴纳金额
    @TableField(value="current_period_actual_due")
    private BigDecimal currentPeriodActualDue; // 本期退还/调动金额
    @TableField(value="include_current_period_actual_actual_due")
    private BigDecimal includeCurrentPeriodActualActualDue; // 含本期实际缴纳金额
    @TableField(value="type")
    private Integer type; // 当前单据类型（1-退还，2-调动）
    @TableField(value="confirm_status")
    private Integer confirmStatus; // 确认状态（1-待确认，2-确认中，3-已确认）
    @JsonFormat(pattern = "yyyy-MM-dd hh:mm:ss", timezone = "GMT+8")
    @TableField(value="confirm_time")
    private Timestamp confirmTime; // 确认时间
    @TableField(value="confirmer")
    private String confirmer; // 确认人
    @TableField(value="approved_output_value")
    private BigDecimal approvedOutputValue; // 退还/调动前一期审定产值
    @TableField(value="include_current_period_actual_actual_percentage")
    private BigDecimal includeCurrentPeriodActualActualPercentage; // 含本期实际缴纳占比
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="refund_date")
    private Date refundDate; // 退还/调动日期
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目code
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="org_code")
    private String orgCode; // 组织code
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="stage")
    private Integer stage; // 是否分期 1-分期 2-不分期

    @TableField(exist = false)
    private String opt; // 确认操作

    public String getOpt() {
        return opt;
    }

    public void setOpt(String opt) {
        this.opt = opt;
    }

    public Integer getStage() {
        return stage;
    }

    public void setStage(Integer stage) {
        this.stage = stage;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getEmployeeSchedulesId() {
        return employeeSchedulesId;
    }

    public void setEmployeeSchedulesId(Long employeeSchedulesId) {
        this.employeeSchedulesId = employeeSchedulesId;
    }
    public String getEmployeeSchedulesName() {
        return employeeSchedulesName;
    }

    public void setEmployeeSchedulesName(String employeeSchedulesName) {
        this.employeeSchedulesName = employeeSchedulesName;
    }
    public String getEmployeeSchedulesCode() {
        return employeeSchedulesCode;
    }

    public void setEmployeeSchedulesCode(String employeeSchedulesCode) {
        this.employeeSchedulesCode = employeeSchedulesCode;
    }
    public BigDecimal getDue() {
        return due;
    }

    public void setDue(BigDecimal due) {
        this.due = due;
    }
    public BigDecimal getActualDue() {
        return actualDue;
    }

    public void setActualDue(BigDecimal actualDue) {
        this.actualDue = actualDue;
    }
    public BigDecimal getCumulativeDue() {
        return cumulativeDue;
    }

    public void setCumulativeDue(BigDecimal cumulativeDue) {
        this.cumulativeDue = cumulativeDue;
    }
    public BigDecimal getCurrentPeriodActualDue() {
        return currentPeriodActualDue;
    }

    public void setCurrentPeriodActualDue(BigDecimal currentPeriodActualDue) {
        this.currentPeriodActualDue = currentPeriodActualDue;
    }
    public BigDecimal getIncludeCurrentPeriodActualActualDue() {
        return includeCurrentPeriodActualActualDue;
    }

    public void setIncludeCurrentPeriodActualActualDue(BigDecimal includeCurrentPeriodActualActualDue) {
        this.includeCurrentPeriodActualActualDue = includeCurrentPeriodActualActualDue;
    }
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
    public Integer getConfirmStatus() {
        return confirmStatus;
    }

    public void setConfirmStatus(Integer confirmStatus) {
        this.confirmStatus = confirmStatus;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Timestamp confirmTime) {
        this.confirmTime = confirmTime;
    }

    public String getConfirmer() {
        return confirmer;
    }

    public void setConfirmer(String confirmer) {
        this.confirmer = confirmer;
    }

    public BigDecimal getApprovedOutputValue() {
        return approvedOutputValue;
    }

    public void setApprovedOutputValue(BigDecimal approvedOutputValue) {
        this.approvedOutputValue = approvedOutputValue;
    }
    public BigDecimal getIncludeCurrentPeriodActualActualPercentage() {
        return includeCurrentPeriodActualActualPercentage;
    }

    public void setIncludeCurrentPeriodActualActualPercentage(BigDecimal includeCurrentPeriodActualActualPercentage) {
        this.includeCurrentPeriodActualActualPercentage = includeCurrentPeriodActualActualPercentage;
    }
    public Date getRefundDate() {
        return refundDate;
    }

    public void setRefundDate(Date refundDate) {
        this.refundDate = refundDate;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
