package com.ejianc.business.jltest.margin.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.jltest.margin.bean.*;
import com.ejianc.business.jltest.margin.service.ICashAmountService;
import com.ejianc.business.jltest.margin.service.ICashService;
import com.ejianc.business.jltest.margin.vo.AssessCashVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jltest.margin.mapper.AssessCashMapper;
import com.ejianc.business.jltest.margin.service.IAssessCashService;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 考核兑现审批表
 *
 * @author generator
 *
 */
@Service("assessCashService")
public class AssessCashServiceImpl extends BaseServiceImpl<AssessCashMapper, AssessCashEntity> implements IAssessCashService{
    private static final String BILL_CODE = "ASSESS-CODE";//此处需要根据实际修改
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ICashService cashService;
    @Autowired
    private ICashAmountService cashAmountService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    //新增或者修改
    @Override
    public AssessCashVO saveUpdate(AssessCashVO saveOrUpdateVO) {
        //新增
        AssessCashEntity entity = BeanMapper.map(saveOrUpdateVO, AssessCashEntity.class);
        if(entity.getId() == null || entity.getId() == 0&& StringUtils.isEmpty(entity.getBillCode())){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //修改  将上游数据的状态改为0  ，重新增加之后的改为1
        if (entity.getId() != null && entity.getId() != 0){
            List<AssessCashDetailEntity> assessCashDetailList = super.selectById(entity.getId()).getAssessCashDetailList();
            logger.info("要求改的数据数量"+assessCashDetailList.size());
            for (AssessCashDetailEntity cashDetail:assessCashDetailList) {
                LambdaUpdateWrapper<CashEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(CashEntity::getId,cashDetail.getCashId());
                updateWrapper.set(CashEntity::getFlag,0);
                cashService.update(updateWrapper);
            }
            List<AssessCashDetailSumEntity> cashDetailSumEntityList = super.selectById(entity.getId()).getAssessCashDetailSumList();
            logger.info("要求改的数据数量汇总"+cashDetailSumEntityList.size());
            for (AssessCashDetailSumEntity cashDetail:cashDetailSumEntityList) {
                LambdaUpdateWrapper<CashAmountEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(CashAmountEntity::getId,cashDetail.getCashSumId());
                updateWrapper.set(CashAmountEntity::getFlag,0);
                cashAmountService.update(updateWrapper);
            }
        }
        super.saveOrUpdate(entity, false);
        //修改上游数据状态  全删了新增
        List<AssessCashDetailEntity> assessCashDetailList = entity.getAssessCashDetailList();
        for (AssessCashDetailEntity cashDetail:assessCashDetailList) {
            LambdaUpdateWrapper<CashEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(CashEntity::getId,cashDetail.getCashId());
            updateWrapper.set(CashEntity::getFlag,1);
            cashService.update(updateWrapper);
        }
        List<AssessCashDetailSumEntity> cashDetailSumEntityList = entity.getAssessCashDetailSumList();
        for (AssessCashDetailSumEntity cashDetail:cashDetailSumEntityList) {
            LambdaUpdateWrapper<CashAmountEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(CashAmountEntity::getId,cashDetail.getCashSumId());
            updateWrapper.set(CashAmountEntity::getFlag,1);
            cashAmountService.update(updateWrapper);
        }

        AssessCashVO vo = BeanMapper.map(entity, AssessCashVO.class);
        return vo;
    }
    /**
        删除表中的数据并更新上游单据信息
     */
    @Override
    public void removeByIdUpdateDetail(List<AssessCashVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (AssessCashVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        List<Long> ids = vos.stream().map(AssessCashVO::getId).collect(Collectors.toList());
        Collection<AssessCashEntity> assessCashEntities = super.listByIds(ids);

        //修改上游数据状态
        for (AssessCashEntity assessCashEntity :assessCashEntities){
            List<AssessCashDetailEntity> assessCashDetailList = assessCashEntity.getAssessCashDetailList();
            for (AssessCashDetailEntity cashDetail:assessCashDetailList) {
                LambdaUpdateWrapper<CashEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(CashEntity::getId,cashDetail.getCashId());
                updateWrapper.set(CashEntity::getFlag,0);
                cashService.update(updateWrapper);
            }
            List<AssessCashDetailSumEntity> assessCashDetailSumList = assessCashEntity.getAssessCashDetailSumList();
            for (AssessCashDetailSumEntity cashDetailSum:assessCashDetailSumList) {
                LambdaUpdateWrapper<CashAmountEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(CashAmountEntity::getId,cashDetailSum.getCashSumId());
                updateWrapper.set(CashAmountEntity::getFlag,0);
                cashAmountService.update(updateWrapper);
            }
        }
        super.removeByIds(ids,true);
    }
}
