package com.ejianc.business.jltest.margin.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jltest.margin.bean.*;
import com.ejianc.business.jltest.margin.controller.DirectEmployeeController;
import com.ejianc.business.jltest.margin.service.IDirectEmployeeService;
import com.ejianc.business.jltest.margin.service.IDirectLedgeService;
import com.ejianc.business.jltest.margin.service.IMoneyRefundService;
import com.ejianc.business.jltest.margin.service.IRiskPayConfirmationService;
import com.ejianc.business.jltest.margin.vo.DirectLedgeVO;
import com.ejianc.business.jltest.margin.vo.DirectPaidEmployeeVO;
import com.ejianc.business.jltest.margin.vo.DirectPaidRecordVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Service("directEmployee")
public class DirectEmployeeBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IDirectEmployeeService directEmployeeService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private IDirectLedgeService directLedgeService;
    @Autowired
    private IMoneyRefundService moneyRefundService;
    @Autowired
    private IRiskPayConfirmationService riskPayConfirmationService;

    private static final String BILL_CODE = "DIRECT_EMPLOYEE_CODE";//此处需要根据实际修改

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批后回调
     *
     * @param billId       //单据id
     * @param state        //单据状态
     * @param billTypeCode //单据类型code
     * @param taskId       //该流程id
     * @param isEnd        //该节点是否结束
     * @return
     */
    @Override
    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
//        //TODO
//        List<MoneyRefundEntity> moneyRefundList = moneyRefundService.list(new QueryWrapper<MoneyRefundEntity>().eq("employee_schedules_id", billId));
//        List<RiskPayConfirmationEntity> riskPayConfirmationList = riskPayConfirmationService.list(new QueryWrapper<RiskPayConfirmationEntity>().eq("employee_dedail_id", billId));
//        DirectEmployeeEntity directEmployee = directEmployeeService.selectById(billId);
//        DirectLedgeVO saveOrUpdateVO = new DirectLedgeVO();
//        saveOrUpdateVO.setOrgId(directEmployee.getOrgId());
//        saveOrUpdateVO.setOrgName(directEmployee.getOrgName());
//        saveOrUpdateVO.setOrgCode(directEmployee.getOrgCode());
//        saveOrUpdateVO.setYear(directEmployee.getYear());
//        saveOrUpdateVO.setPayableMny(directEmployee.getEmployeeMny());
//
//        saveOrUpdateVO.setDirectPaidEmployeeList(new ArrayList<>());
//        for (DirectEmployeeDetailEntity employee : directEmployee.getDetailList()) {
//            DirectPaidEmployeeVO paidEmployee = new DirectPaidEmployeeVO();
//            EmployeeVO data = employeeApi.getById(employee.getEmployeeId()).getData();
//            paidEmployee.setName(data.getName());
//            paidEmployee.setRole(data.getRoleName());
//            paidEmployee.setPhone(data.getMobilePhone());
//            paidEmployee.setPayableMny(employee.getMarginMny());
//            paidEmployee.setActualMny(employee.getMarginActual());
//            paidEmployee.setActualRatio(employee.getMarginRatio());
//            paidEmployee.setInTime(new Date());
//            saveOrUpdateVO.getDirectPaidEmployeeList().add(paidEmployee);
//        }
//
//        saveOrUpdateVO.setDirectPaidRecordList(new ArrayList<>());
//        for (MoneyRefundEntity moneyRefund : moneyRefundList) {
//            DirectPaidRecordVO directPaidRecord = new DirectPaidRecordVO();
//            directPaidRecord.setEmployeeId(moneyRefund.getEmployeeId());
//            directPaidRecord.setEmployeeName(moneyRefund.getEmployeeName());
//            directPaidRecord.setName(moneyRefund.getEmployeeName());
//            saveOrUpdateVO.getDirectPaidRecordList().add(directPaidRecord);
//        }
//
//
//        DirectLedgeEntity entity = BeanMapper.map(saveOrUpdateVO, DirectLedgeEntity.class);
//        if (entity.getId() == null || entity.getId() == 0) {
//            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
//            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//            if (billCode.isSuccess()) {
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//            } else {
//                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//            }
//        }
//        directLedgeService.saveOrUpdate(entity, false);
//        DirectLedgeVO vo = BeanMapper.map(entity, DirectLedgeVO.class);
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
