/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jltest.margin.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jltest.margin.bean.DirectEmployeeDetailEntity;
import com.ejianc.business.jltest.margin.bean.DirectEmployeeEntity;
import com.ejianc.business.jltest.margin.bean.InspiritLossDetailEntity;
import com.ejianc.business.jltest.margin.bean.InspiritLossEntity;
import com.ejianc.business.jltest.margin.service.IAssessCashService;
import com.ejianc.business.jltest.margin.service.IDirectEmployeeService;
import com.ejianc.business.jltest.margin.service.IInspiritLossService;
import com.ejianc.business.jltest.margin.vo.InspiritLossDetailVO;
import com.ejianc.business.jltest.margin.vo.InspiritLossVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"inspiritLoss"})
public class InspiritLossController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IEmployeeApi iEmployeeApi;
    @Autowired
    private IRoleApi roleApi;
    private static final String BILL_CODE = "INSPIRIT_LOSS";
    @Autowired
    private IInspiritLossService service;
    @Autowired
    private IDirectEmployeeService directEmployeeService;
    @Autowired
    private IAssessCashService assessCashService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InspiritLossVO> saveOrUpdate(@RequestBody InspiritLossVO saveOrUpdateVO) {
        InspiritLossEntity entity = (InspiritLossEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, InspiritLossEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        InspiritLossVO vo = (InspiritLossVO)BeanMapper.map((Object)((Object)entity), InspiritLossVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InspiritLossVO> queryDetail(Long id) {
        InspiritLossEntity entity = (InspiritLossEntity)((Object)this.service.selectById(id));
        InspiritLossVO vo = (InspiritLossVO)BeanMapper.map((Object)((Object)entity), InspiritLossVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryEmployeeDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InspiritLossVO> queryEmployeeDetail(Long id) {
        DirectEmployeeEntity entity = (DirectEmployeeEntity)((Object)this.directEmployeeService.selectById(id));
        List<DirectEmployeeDetailEntity> detailList = entity.getDetailList();
        InspiritLossVO inspiritLossVO = new InspiritLossVO();
        ArrayList<InspiritLossDetailEntity> inspiritLossDetailEntities = new ArrayList<InspiritLossDetailEntity>();
        for (DirectEmployeeDetailEntity detailEntity : detailList) {
            InspiritLossDetailEntity inspiritLossDetailEntity = new InspiritLossDetailEntity();
            inspiritLossDetailEntity.setDetailCode(entity.getBillCode());
            inspiritLossDetailEntity.setDetailId(entity.getId());
            inspiritLossDetailEntity.setDetailName(detailEntity.getEmployeeName());
            CommonResponse employeeApiById = this.iEmployeeApi.getById(detailEntity.getEmployeeId());
            CommonResponse listCommonResponse = this.roleApi.queryRoleByUserId(((EmployeeVO)employeeApiById.getData()).getUserId());
            if (ObjectUtils.isEmpty((Object)listCommonResponse.getData()) || ((List)listCommonResponse.getData()).size() == 0) {
                this.logger.info("\u89d2\u8272\u4fe1\u606f\u4e3a\u7a7a");
            } else {
                List roles = (List)listCommonResponse.getData();
                ArrayList<String> roleName = new ArrayList<String>();
                for (RoleVO roleVO : roles) {
                    roleName.add(roleVO.getName());
                }
                String roleNames = ObjectUtils.getDisplayString(roleName);
                this.logger.info("\u89d2\u8272\u540d\u79f0" + roleNames.substring(1, roleNames.length() - 2) + ";");
                inspiritLossDetailEntity.setDetailRole(roleNames.substring(1, roleNames.length() - 1));
            }
            inspiritLossDetailEntity.setDetailPhone(((EmployeeVO)employeeApiById.getData()).getMobilePhone());
            inspiritLossDetailEntity.setDetailPay(detailEntity.getMarginMny());
            inspiritLossDetailEntity.setDetailPayed(detailEntity.getMarginActual());
            inspiritLossDetailEntity.setDetailPercentage(detailEntity.getMarginRatio());
            inspiritLossDetailEntity.setMemo(detailEntity.getMemo());
            inspiritLossDetailEntities.add(inspiritLossDetailEntity);
        }
        inspiritLossVO.setInspiritLossDetailList(BeanMapper.mapList(inspiritLossDetailEntities, InspiritLossDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)inspiritLossVO);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InspiritLossVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (InspiritLossVO inspiritLossVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InspiritLossVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("org_name");
        fuzzyFields.add("cash_node");
        fuzzyFields.add("employee_name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            if (param.getParams().get("orgId") != null) {
                if (((Parameter)param.getParams().get("orgId")).getValue().toString().equals("true")) {
                    CommonResponse employee = this.iEmployeeApi.getById(InvocationInfoProxy.getUserid());
                    param.getParams().put("orgId", new Parameter("eq", (Object)((EmployeeVO)employee.getData()).getOrgId()));
                } else {
                    param.getParams().put("orgId", new Parameter("in", commonOrgIds));
                }
            }
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InspiritLossVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("org_name");
        fuzzyFields.add("cash_node");
        fuzzyFields.add("employee_name");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (param.getParams().get("orgId") != null) {
            if (((Parameter)param.getParams().get("orgId")).getValue().toString().equals("true")) {
                CommonResponse employee = this.iEmployeeApi.getById(InvocationInfoProxy.getUserid());
                this.logger.info("orgId8888888" + ((EmployeeVO)employee.getData()).getOrgId());
                param.getParams().put("orgId", new Parameter("eq", (Object)((EmployeeVO)employee.getData()).getOrgId()));
            } else {
                param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("InspiritLoss-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refInspiritLossData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InspiritLossVO>> refInspiritLossData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InspiritLossVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryAssessMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> queryAssessMny(Long id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"cash_id", (Object)id);
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        ArrayList<Integer> state = new ArrayList<Integer>();
        state.add(1);
        state.add(3);
        queryWrapper.in((Object)"bill_state", state);
        List list = this.service.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal reduce = list.stream().map(InspiritLossEntity::getIssueAssessMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.logger.info("\u5206\u914d\u7684\u603b\u91d1\u989d\u4e3a\uff1a" + reduce);
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)reduce);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)BigDecimal.ZERO);
    }
}

