/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jltest.margin.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jltest.margin.bean.DirectEmployeeDetailEntity;
import com.ejianc.business.jltest.margin.bean.MoneyRefundEntity;
import com.ejianc.business.jltest.margin.bean.RiskPayConfirmationEntity;
import com.ejianc.business.jltest.margin.service.IDirectEmployeeDetailService;
import com.ejianc.business.jltest.margin.service.IDirectEmployeeService;
import com.ejianc.business.jltest.margin.service.IMoneyRefundService;
import com.ejianc.business.jltest.margin.service.IPaymentDetailsService;
import com.ejianc.business.jltest.margin.service.IRiskPayConfirmationService;
import com.ejianc.business.jltest.margin.vo.MoneyRefundVO;
import com.ejianc.business.jltest.margin.vo.RiskPayConfirmationVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"moneyRefundConfirm"})
public class MoneyRefundConfirmController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "REFUND_CODE";
    @Autowired
    private IMoneyRefundService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IDirectEmployeeDetailService detailService;
    @Autowired
    private IDirectEmployeeService directEmployeeService;
    @Autowired
    private IRiskPayConfirmationService riskPayConfirmationService;
    @Autowired
    private IPaymentDetailsService iPaymentDetailsService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MoneyRefundVO> saveOrUpdate(@RequestBody MoneyRefundVO saveOrUpdateVO) {
        MoneyRefundEntity entity = (MoneyRefundEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MoneyRefundEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        MoneyRefundVO vo = (MoneyRefundVO)BeanMapper.map((Object)((Object)entity), MoneyRefundVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MoneyRefundVO> queryDetail(Long id) {
        MoneyRefundEntity entity = (MoneyRefundEntity)((Object)this.service.selectById(id));
        MoneyRefundVO vo = (MoneyRefundVO)BeanMapper.map((Object)((Object)entity), MoneyRefundVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MoneyRefundVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MoneyRefundVO moneyRefundVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/confirm"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> confirm(@RequestBody MoneyRefundVO vo) {
        MoneyRefundEntity result = (MoneyRefundEntity)((Object)this.service.getById(vo.getId()));
        DirectEmployeeDetailEntity detailEntity = (DirectEmployeeDetailEntity)((Object)this.detailService.getById(result.getEmployeeSchedulesId()));
        detailEntity.setHasRecord(1);
        this.detailService.updateById((Object)detailEntity);
        if (result.getType() == 1) {
            result.setConfirmStatus(3);
            result.setConfirmer(this.sessionManager.getUserContext().getEmployeeName());
            result.setConfirmTime(new Timestamp(new Date().getTime()));
            this.service.updateById((Object)result);
        } else {
            result.setConfirmStatus(3);
            result.setConfirmer(this.sessionManager.getUserContext().getEmployeeName());
            result.setConfirmTime(new Timestamp(new Date().getTime()));
            this.service.updateById((Object)result);
            this.saveRiskPayConfirmation(vo);
        }
        return CommonResponse.success((String)"\u786e\u8ba4\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/confirms"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> confirms(@RequestBody List<MoneyRefundVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MoneyRefundVO vo : vos) {
                MoneyRefundEntity result = (MoneyRefundEntity)((Object)this.service.getById(vo.getId()));
                DirectEmployeeDetailEntity detailEntity = (DirectEmployeeDetailEntity)((Object)this.detailService.getById(result.getEmployeeSchedulesId()));
                detailEntity.setHasRecord(1);
                this.detailService.updateById((Object)detailEntity);
                this.saveRiskPayConfirmation(vo);
            }
        }
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.in(BaseEntity::getId, ids);
        List moneyRefundEntities = this.service.list((Wrapper)lambda);
        List moneyRefundIds = moneyRefundEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
        lambdaUpdateWrapper.in(BaseEntity::getId, moneyRefundIds);
        lambdaUpdateWrapper.set(MoneyRefundEntity::getConfirmStatus, (Object)3);
        lambdaUpdateWrapper.set(MoneyRefundEntity::getConfirmer, (Object)this.sessionManager.getUserContext().getEmployeeName());
        lambdaUpdateWrapper.set(MoneyRefundEntity::getConfirmTime, (Object)new Timestamp(new Date().getTime()));
        this.service.update((Wrapper)lambdaUpdateWrapper);
        return CommonResponse.success((String)"\u786e\u8ba4\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MoneyRefundVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        String searchText = param.getSearchText();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        if (searchText != null) {
            HashMap<String, Parameter> map = new HashMap<String, Parameter>();
            map.put("billCode", new Parameter("like", (Object)searchText));
            param.setParams(map);
            IPage page = this.service.queryPage(param, false);
            if (page.getTotal() == 0L) {
                map.clear();
                map.put("employeeName", new Parameter("like", (Object)searchText));
                param.setParams(map);
                page = this.service.queryPage(param, false);
                if (page.getTotal() == 0L) {
                    map.clear();
                    map.put("orgName", new Parameter("like", (Object)searchText));
                    param.setParams(map);
                    page = this.service.queryPage(param, false);
                }
            }
            Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
            List records = page.getRecords();
            for (int i = 0; i < records.size(); ++i) {
                ((MoneyRefundEntity)((Object)records.get(i))).setOpt("\u786e\u8ba4");
                page.setRecords(records);
            }
            pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MoneyRefundVO.class));
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        param.getParams().put("confirmStatus", new Parameter("eq", (Object)2));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = page.getRecords();
        for (int i = 0; i < records.size(); ++i) {
            ((MoneyRefundEntity)((Object)records.get(i))).setOpt("\u786e\u8ba4");
            page.setRecords(records);
        }
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MoneyRefundVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryConfirmedList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MoneyRefundVO>> queryConfirmedList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        param.getParams().put("confirmStatus", new Parameter("eq", (Object)3));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MoneyRefundVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("confirmStatus", new Parameter("eq", (Object)2));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List resDatas = new ArrayList();
        resDatas = BeanMapper.mapList((Iterable)list, MoneyRefundVO.class);
        for (MoneyRefundVO entity : resDatas) {
            switch (entity.getType()) {
                case 1: {
                    entity.setTypeName("\u9000\u8fd8");
                    break;
                }
                case 2: {
                    entity.setTypeName("\u8c03\u52a8");
                }
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", resDatas);
        ExcelExport.getInstance().export("MoneyRefundConfirm-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExported"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExported(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("confirmStatus", new Parameter("eq", (Object)3));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MoneyRefundConfirmed-export.xlsx", beans, response);
    }

    public void saveRiskPayConfirmation(RiskPayConfirmationVO saveOrUpdateVO) {
        RiskPayConfirmationEntity entity = (RiskPayConfirmationEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, RiskPayConfirmationEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)"RiskFund", (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                System.out.println("billCode = " + (String)billCode.getData());
                this.iPaymentDetailsService.insertOne(entity, entity.getBillCode());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.riskPayConfirmationService.saveOrUpdate((Object)entity, false);
    }

    @RequestMapping(value={"/refMoneyRefundData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MoneyRefundVO>> refMoneyRefundData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MoneyRefundVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public void saveRiskPayConfirmationCode(RiskPayConfirmationVO saveOrUpdateVO) {
        RiskPayConfirmationEntity entity = (RiskPayConfirmationEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, RiskPayConfirmationEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)"RiskFund", (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                System.out.println("billCode = " + (String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.riskPayConfirmationService.saveOrUpdate((Object)entity, false);
        String billCode = entity.getBillCode();
        System.out.println("dasdasd:" + billCode);
        Long transferId = entity.getTransferId();
        System.out.println("transferId     :" + transferId);
        RiskPayConfirmationEntity riskPayConfirmationEntity = new RiskPayConfirmationEntity();
        this.iPaymentDetailsService.insertOne(entity, billCode);
    }

    public String saveRiskPayConfirmation(MoneyRefundVO vo) {
        RiskPayConfirmationVO riskPayConfirmationVO = new RiskPayConfirmationVO();
        riskPayConfirmationVO.setEmployeeDetailId(vo.getEmployeeSchedulesId());
        riskPayConfirmationVO.setOrgId(vo.getMobilizeOrgId());
        riskPayConfirmationVO.setOrgName(vo.getMobilizeOrg());
        riskPayConfirmationVO.setPayableAmount(vo.getDue());
        riskPayConfirmationVO.setCurrentPaymentAmount(vo.getCurrentPeriodActualDue());
        riskPayConfirmationVO.setPaymentAmountTotal(vo.getIncludeCurrentPeriodActualActualDue());
        riskPayConfirmationVO.setProportion(vo.getIncludeCurrentPeriodActualActualPercentage());
        riskPayConfirmationVO.setIsStaged(Integer.valueOf(2));
        riskPayConfirmationVO.setPaymentDate(vo.getRefundDate());
        riskPayConfirmationVO.setEmployeeId(vo.getEmployeeId());
        riskPayConfirmationVO.setEmployeeName(vo.getEmployeeName());
        riskPayConfirmationVO.setDepartmentId(vo.getDepartmentId());
        riskPayConfirmationVO.setEmployeeName(vo.getEmployeeName());
        riskPayConfirmationVO.setBillState(Integer.valueOf(1));
        riskPayConfirmationVO.setApplyForTime(vo.getRefundDate());
        riskPayConfirmationVO.setConfirmTime((Date)vo.getConfirmTime());
        riskPayConfirmationVO.setApplyPeopleName(vo.getEmployeeName());
        riskPayConfirmationVO.setConfirmationState(Integer.valueOf(1));
        riskPayConfirmationVO.setIsok(Integer.valueOf(1));
        riskPayConfirmationVO.setSubmitter(vo.getEmployeeName());
        riskPayConfirmationVO.setConfirmPerson(vo.getConfirmer());
        riskPayConfirmationVO.setType(Integer.valueOf(2));
        riskPayConfirmationVO.setTransferId(vo.getId());
        riskPayConfirmationVO.setRemainingPaymentAmount(vo.getDue().subtract(vo.getIncludeCurrentPeriodActualActualDue()));
        this.saveRiskPayConfirmationCode(riskPayConfirmationVO);
        return "success";
    }
}

