/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jltest.margin.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jltest.margin.bean.DirectEmployeeDetailEntity;
import com.ejianc.business.jltest.margin.bean.PaymentDetailsEntity;
import com.ejianc.business.jltest.margin.bean.RiskPayConfirmationEntity;
import com.ejianc.business.jltest.margin.service.IDirectEmployeeDetailService;
import com.ejianc.business.jltest.margin.service.IPaymentDetailsService;
import com.ejianc.business.jltest.margin.service.IRiskPayConfirmationService;
import com.ejianc.business.jltest.margin.vo.RiskPayConfirmationVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"riskPayConfirmationTabsList"})
public class SubmitRiskPayConfirmationController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Risk";
    @Autowired
    private IRiskPayConfirmationService service;
    @Autowired
    private IPaymentDetailsService paymentDetailsService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IDirectEmployeeDetailService iDirectEmployeeDetailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RiskPayConfirmationVO> saveOrUpdate(@RequestBody RiskPayConfirmationVO saveOrUpdateVO) {
        RiskPayConfirmationEntity entity = (RiskPayConfirmationEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, RiskPayConfirmationEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        RiskPayConfirmationVO vo = (RiskPayConfirmationVO)BeanMapper.map((Object)((Object)entity), RiskPayConfirmationVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RiskPayConfirmationVO> queryDetail(Long id) {
        RiskPayConfirmationEntity entity = (RiskPayConfirmationEntity)((Object)this.service.selectById(id));
        RiskPayConfirmationVO vo = (RiskPayConfirmationVO)BeanMapper.map((Object)((Object)entity), RiskPayConfirmationVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RiskPayConfirmationVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (RiskPayConfirmationVO object : vos) {
            }
        }
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        for (Long id : ids) {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            wrapper1.eq(BaseEntity::getId, (Object)id);
            RiskPayConfirmationEntity one = (RiskPayConfirmationEntity)((Object)this.service.getOne((Wrapper)wrapper1));
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            wrapper2.eq(BaseEntity::getId, (Object)one.getEmployeeDetailId());
            DirectEmployeeDetailEntity one1 = (DirectEmployeeDetailEntity)((Object)this.iDirectEmployeeDetailService.getOne((Wrapper)wrapper2));
            one1.setHasRecord(1);
            this.iDirectEmployeeDetailService.updateById((Object)one1);
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RiskPayConfirmationVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("payableAmount");
        fuzzyFields.add("paymentDate");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        param.getParams().put("isok", new Parameter("eq", (Object)1));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RiskPayConfirmationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryList1"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RiskPayConfirmationVO>> queryList1(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("payableAmount");
        fuzzyFields.add("paymentDate");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        param.getParams().put("isok", new Parameter("eq", (Object)1));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RiskPayConfirmationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("payableAmount");
        fuzzyFields.add("paymentDate");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("RiskPayConfirmation1-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refRiskPayConfirmationData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RiskPayConfirmationVO>> refRiskPayConfirmationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RiskPayConfirmationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"/updateB1"})
    @ResponseBody
    public CommonResponse updateB1(@RequestBody String[] ids) {
        for (String id : ids) {
            try {
                RiskPayConfirmationEntity riskPayConfirmationEntity = (RiskPayConfirmationEntity)((Object)this.service.selectById((Serializable)((Object)id)));
                riskPayConfirmationEntity.setIsok(1);
                PaymentDetailsEntity paymentDetailsEntity = (PaymentDetailsEntity)((Object)this.paymentDetailsService.selectById((Serializable)((Object)id)));
                if (paymentDetailsEntity != null) {
                    paymentDetailsEntity.setConfirmationState(1);
                    this.paymentDetailsService.updateById((Object)paymentDetailsEntity);
                }
                riskPayConfirmationEntity.setSubmitter(this.sessionManager.getUserContext().getEmployeeName());
                riskPayConfirmationEntity.setConfirmTime(new Date());
                riskPayConfirmationEntity.setConfirmPerson(this.sessionManager.getUserContext().getEmployeeName());
                this.service.updateById((Object)riskPayConfirmationEntity);
            }
            catch (Exception e) {
                this.logger.error("updateB  id:{}", (Object)id, (Object)e);
                return CommonResponse.error((String)"\u6570\u636e\u66f4\u65b0\u5931\u8d25");
            }
        }
        return CommonResponse.success((String)"\u6570\u636e\u66f4\u65b0\u6210\u529f");
    }

    @PostMapping(value={"/delete1"})
    @ResponseBody
    public CommonResponse delete1(@RequestBody String[] ids) {
        for (String id : ids) {
            try {
                this.service.removeById((Serializable)((Object)id));
            }
            catch (Exception e) {
                this.logger.error("updateB  id:{}", (Object)id, (Object)e);
                return CommonResponse.error((String)"\u6570\u636e\u66f4\u65b0\u5931\u8d25");
            }
        }
        return CommonResponse.success((String)"\u6570\u636e\u66f4\u65b0\u6210\u529f");
    }

    @GetMapping(value={"/selectByid"})
    @ResponseBody
    public CommonResponse selectByid(String id) {
        System.out.println(id);
        RiskPayConfirmationEntity riskPayConfirmationEntity = (RiskPayConfirmationEntity)((Object)this.service.selectById((Serializable)((Object)id)));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", riskPayConfirmationEntity.getConfirmPerson());
        map.put("time", riskPayConfirmationEntity.getConfirmTime());
        System.out.println("map:" + map);
        return CommonResponse.success((String)"\u6570\u636e\u66f4\u65b0\u6210\u529f", map);
    }
}

