/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jltest.orgtest.controller;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jltest.orgtest.bean.PlancDetailEntity;
import com.ejianc.business.jltest.orgtest.bean.PlancEntity;
import com.ejianc.business.jltest.orgtest.bean.SafeteamcEntity;
import com.ejianc.business.jltest.orgtest.service.IPlancDetailService;
import com.ejianc.business.jltest.orgtest.service.IPlancService;
import com.ejianc.business.jltest.orgtest.service.ISafeteamcService;
import com.ejianc.business.jltest.orgtest.vo.PlancDetailVO;
import com.ejianc.business.jltest.orgtest.vo.PlancListVO;
import com.ejianc.business.jltest.orgtest.vo.PlancVO;
import com.ejianc.business.jltest.utils.TreeNodeBUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"planc"})
public class PlancController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PLANC_CODE";
    @Autowired
    private ISafeteamcService safeteamcService;
    @Autowired
    private IPlancService service;
    @Autowired
    private IPlancDetailService plancDetailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PlancVO> saveOrUpdate(@RequestBody PlancVO saveOrUpdateVO) {
        PlancEntity entity = (PlancEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PlancEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        Long safeteamcId = entity.getSafeteamcId();
        SafeteamcEntity safeteamc = (SafeteamcEntity)((Object)this.safeteamcService.getById(safeteamcId));
        safeteamc.setPlancFlag(2);
        this.safeteamcService.updateById((Object)safeteamc);
        this.service.saveOrUpdate((Object)entity, false);
        PlancVO vo = (PlancVO)BeanMapper.map((Object)((Object)entity), PlancVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PlancVO> queryDetail(Long id) {
        PlancEntity entity = (PlancEntity)((Object)this.service.selectById(id));
        PlancVO vo = (PlancVO)BeanMapper.map((Object)((Object)entity), PlancVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlancVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PlancVO plancVO : vos) {
            }
        }
        List ids = vos.stream().map(PlancVO::getSafeteamcId).collect(Collectors.toList());
        Collection safeteamcEntities = this.safeteamcService.listByIds(ids);
        for (SafeteamcEntity safeteamc : safeteamcEntities) {
            safeteamc.setPlancFlag(1);
        }
        this.safeteamcService.updateBatchById(safeteamcEntities);
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PlancListVO>> queryList(@RequestBody QueryParam param) {
        Map params = param.getParams();
        Parameter lister = (Parameter)params.remove("islister");
        if (!ObjectUtil.isEmpty((Object)lister) && "1".equals(lister.getValue())) {
            params.put("listerId", new Parameter("eq", (Object)this.sessionManager.getUserContext().getEmployeeId()));
        }
        param.setParams(params);
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List resDatas = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            resDatas = BeanMapper.mapList((Iterable)page.getRecords(), PlancListVO.class);
            ArrayList ids = new ArrayList();
            HashMap map = new HashMap();
            if (CollectionUtils.isNotEmpty(resDatas)) {
                resDatas.forEach(e -> {
                    ids.add(e.getId());
                    map.put(e.getId(), e.getBillState());
                });
            }
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.in(PlancDetailEntity::getPlanId, ids);
            List resList = this.plancDetailService.list((Wrapper)lambda);
            List plancDetailVOList = BeanMapper.mapList((Iterable)resList, PlancListVO.class);
            if (CollectionUtils.isNotEmpty((Collection)plancDetailVOList)) {
                plancDetailVOList.forEach(e -> {
                    e.setBillState((Integer)map.get(e.getPlanId()));
                    e.setPlanMny(e.getDetailMny());
                    e.setOrgName(e.getDetailOrgName());
                    e.setPlanName(e.getDetailName());
                });
                resDatas.addAll(plancDetailVOList);
            }
            pageData.setRecords(TreeNodeBUtil.buildTree(resDatas));
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PlancListVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List resDatas = new ArrayList();
        HashMap beans = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resDatas = BeanMapper.mapList((Iterable)list, PlancListVO.class);
            ArrayList ids = new ArrayList();
            HashMap map = new HashMap();
            if (CollectionUtils.isNotEmpty(resDatas)) {
                resDatas.forEach(e -> {
                    ids.add(e.getId());
                    map.put(e.getId(), e.getBillState());
                });
            }
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.in(PlancDetailEntity::getPlanId, ids);
            List resList = this.plancDetailService.list((Wrapper)lambda);
            List plancDetailVOList = BeanMapper.mapList((Iterable)resList, PlancListVO.class);
            if (CollectionUtils.isNotEmpty((Collection)plancDetailVOList)) {
                plancDetailVOList.forEach(e -> {
                    e.setBillState((Integer)map.get(e.getPlanId()));
                    e.setPlanName(e.getDetailName());
                    e.setPlanMny(e.getDetailMny());
                    e.setOrgName(e.getDetailOrgName());
                    e.setPlanName(e.getDetailName());
                });
                resDatas.addAll(plancDetailVOList);
            }
            resDatas = TreeNodeBUtil.buildTree(resDatas);
            beans.put("records", resDatas);
        } else {
            beans.put("records", resDatas);
        }
        for (PlancListVO entity : resDatas) {
            switch (entity.getUrgencyDegree()) {
                case 1: {
                    entity.setUrgencyDegreeName("\u4e00\u822c");
                    break;
                }
                case 2: {
                    entity.setUrgencyDegreeName("\u6025");
                    break;
                }
                case 3: {
                    entity.setUrgencyDegreeName("\u7279\u6025");
                }
            }
            switch (entity.getSecurityClass()) {
                case 1: {
                    entity.setSecurityClassName("\u516c\u5f00");
                    break;
                }
                case 2: {
                    entity.setSecurityClassName("\u79d8\u5bc6");
                    break;
                }
                case 3: {
                    entity.setSecurityClassName("\u673a\u5bc6");
                    break;
                }
                case 4: {
                    entity.setSecurityClassName("\u7edd\u5bc6");
                }
            }
        }
        ExcelExport.getInstance().export("Planc-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPlancData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PlancVO>> refPlancData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PlancVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/downloadInfo"})
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"PlancDetail-import.xlsx", (String)"\u660e\u7ec6\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<PlancDetailVO> successList = new ArrayList<PlancDetailVO>();
        ArrayList<PlancDetailVO> errorList = new ArrayList<PlancDetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                PlancDetailVO detailVO = new PlancDetailVO();
                detailVO.setId(Long.valueOf(IdWorker.getId()));
                String detailName = (String)datas.get(0);
                if (StringUtils.isEmpty((CharSequence)detailName)) {
                    detailVO.setErrorMsg("\u5b89\u5168\u8d39\u7528\u9879\u76ee\u540d\u79f0\u4e3a\u7a7a");
                    errorList.add(detailVO);
                    continue;
                }
                detailVO.setDetailName(detailName);
                try {
                    String detailMny = (String)datas.get(1);
                    detailVO.setDetailMny(StringUtils.isNotBlank((CharSequence)detailMny) ? new BigDecimal(detailMny) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u62df\u6295\u5165\u91d1\u989d\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String detailMaxMny = (String)datas.get(2);
                    detailVO.setDetailMaxMny(StringUtils.isNotBlank((CharSequence)detailMaxMny) ? new BigDecimal(detailMaxMny) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u6700\u5927\u62df\u6295\u5165\u91d1\u989d\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                if (detailVO.getDetailMny().compareTo(detailVO.getDetailMaxMny()) > 0) {
                    detailVO.setErrorMsg("\u62df\u6295\u5165\u91d1\u989d\u8d85\u51fa\u6700\u5927\u91d1\u989d\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                String orgName = (String)datas.get(3);
                CommonResponse orgResult = this.iOrgApi.findByNameAndTenantId(orgName, Long.valueOf(999999L));
                if (!orgResult.isSuccess()) {
                    detailVO.setErrorMsg("\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                OrgVO orgVO = (OrgVO)orgResult.getData();
                if (ObjectUtil.isEmpty((Object)orgVO)) {
                    detailVO.setErrorMsg("\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                detailVO.setDetailOrgId(orgVO.getId());
                detailVO.setDetailOrgName(orgVO.getName());
                String orgType = (String)datas.get(4);
                if (orgType.equals("\u96c6\u56e2")) {
                    detailVO.setDetailOrgType(Integer.valueOf(1));
                } else if (orgType.equals("\u5206\u516c\u53f8")) {
                    detailVO.setDetailOrgType(Integer.valueOf(2));
                } else if (orgType.equals("\u9879\u76ee\u90e8")) {
                    detailVO.setDetailOrgType(Integer.valueOf(3));
                } else {
                    detailVO.setErrorMsg("\u7ec4\u7ec7\u7c7b\u578b\u4e0d\u5b58\u5728" + orgType + "\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

