/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jltest.orgtest.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jltest.orgtest.bean.PlandDetailEntity;
import com.ejianc.business.jltest.orgtest.bean.PlandEntity;
import com.ejianc.business.jltest.orgtest.bean.SafeteamdEntity;
import com.ejianc.business.jltest.orgtest.service.IPlandDetailService;
import com.ejianc.business.jltest.orgtest.service.IPlandService;
import com.ejianc.business.jltest.orgtest.service.ISafeteamdService;
import com.ejianc.business.jltest.orgtest.vo.PlandDetailVO;
import com.ejianc.business.jltest.orgtest.vo.PlandTreeVO;
import com.ejianc.business.jltest.orgtest.vo.PlandVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"pland"})
public class PlandController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PLAND_CODE";
    @Autowired
    private IPlandService service;
    @Autowired
    private IPlandDetailService detailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISafeteamdService safeteamdService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PlandVO> saveOrUpdate(@RequestBody PlandVO saveOrUpdateVO) {
        PlandEntity entity = (PlandEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PlandEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveUpdate(saveOrUpdateVO);
        this.service.saveOrUpdate((Object)entity, false);
        PlandVO vo = (PlandVO)BeanMapper.map((Object)((Object)entity), PlandVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PlandVO> queryDetail(Long id) {
        PlandEntity entity = (PlandEntity)((Object)this.service.selectById(id));
        PlandVO vo = (PlandVO)BeanMapper.map((Object)((Object)entity), PlandVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlandVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.in(BaseEntity::getId, ids);
            List plandEntityList = this.service.list((Wrapper)lambda);
            List safeteamdIds = plandEntityList.stream().map(PlandEntity::getSafeteamdId).collect(Collectors.toList());
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(BaseEntity::getId, safeteamdIds);
            updateWrapper.set(SafeteamdEntity::getPlanFlag, (Object)1);
            this.safeteamdService.update((Wrapper)updateWrapper);
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PlandTreeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        if (param.getParams().get("employeeId") != null) {
            Long employeeId = this.sessionManager.getUserContext().getEmployeeId();
            if (((Boolean)((Parameter)param.getParams().get("employeeId")).getValue()).booleanValue()) {
                param.getParams().put("employeeId", new Parameter("eq", (Object)employeeId));
            } else {
                param.getParams().put("employeeId", new Parameter("ne", (Object)employeeId));
            }
            param.getParams().remove("employeeId");
        }
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List resDatas = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            resDatas = BeanMapper.mapList((Iterable)page.getRecords(), PlandTreeVO.class);
            ArrayList ids = new ArrayList();
            HashMap map = new HashMap();
            if (CollectionUtils.isNotEmpty(resDatas)) {
                resDatas.forEach(e -> {
                    ids.add(e.getId());
                    map.put(e.getId(), e.getBillState());
                });
            }
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.in(PlandDetailEntity::getPlandId, ids);
            List resList = this.detailService.list((Wrapper)lambda);
            List plandTreeVOList = BeanMapper.mapList((Iterable)resList, PlandTreeVO.class);
            if (CollectionUtils.isNotEmpty((Collection)plandTreeVOList)) {
                plandTreeVOList.forEach(e -> {
                    e.setBillState((Integer)map.get(e.getPlandId()));
                    e.setProjectName(e.getProjectName());
                    e.setUsetime(e.getUsetime());
                    e.setProposedInvestmentMny(e.getProposedInvestmentMny());
                });
                resDatas.addAll(plandTreeVOList);
            }
            pageData.setRecords(TreeNodeBUtil.buildTree(resDatas));
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PlandTreeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        ArrayList ids = new ArrayList();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List resDatas = new ArrayList();
        HashMap map = new HashMap();
        HashMap beans = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resDatas = BeanMapper.mapList((Iterable)list, PlandTreeVO.class);
            if (CollectionUtils.isNotEmpty(resDatas)) {
                resDatas.forEach(e -> {
                    ids.add(e.getId());
                    map.put(e.getId(), e.getBillState());
                });
            }
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.in(PlandDetailEntity::getPlandId, ids);
            List resList = this.detailService.list((Wrapper)lambda);
            List plandTreeVOList = BeanMapper.mapList((Iterable)resList, PlandTreeVO.class);
            if (CollectionUtils.isNotEmpty((Collection)plandTreeVOList)) {
                plandTreeVOList.forEach(e -> {
                    e.setBillState((Integer)map.get(e.getPlandId()));
                    e.setProjectName(e.getProjectName());
                    e.setUsetime(e.getUsetime());
                    e.setProposedInvestmentMny(e.getProposedInvestmentMny());
                });
                resDatas.addAll(plandTreeVOList);
            }
            resDatas = TreeNodeBUtil.buildTree(resDatas);
            beans.put("records", resDatas);
        } else {
            beans.put("records", resDatas);
        }
        for (PlandTreeVO entity : resDatas) {
            switch (entity.getUrgency()) {
                case 0: {
                    entity.setUrgencyName("\u4e00\u822c");
                    break;
                }
                case 1: {
                    entity.setUrgencyName("\u6025");
                    break;
                }
                case 2: {
                    entity.setUrgencyName("\u7279\u6025");
                }
            }
            switch (entity.getSecretLevel()) {
                case 0: {
                    entity.setSecretLevelName("\u516c\u5f00");
                    break;
                }
                case 1: {
                    entity.setSecretLevelName("\u79d8\u5bc6");
                    break;
                }
                case 2: {
                    entity.setSecretLevelName("\u673a\u5bc6");
                    break;
                }
                case 3: {
                    entity.setSecretLevelName("\u7edd\u5bc6");
                }
            }
        }
        ExcelExport.getInstance().export("PlandTree-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPlandData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PlandVO>> refPlandData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PlandVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/downloadInfo"})
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"PlandDetail-import.xlsx", (String)"\u660e\u7ec6\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<PlandDetailVO> successList = new ArrayList<PlandDetailVO>();
        ArrayList<PlandDetailVO> errorList = new ArrayList<PlandDetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                PlandDetailVO detailVO = new PlandDetailVO();
                detailVO.setId(Long.valueOf(IdWorker.getId()));
                String plandName = (String)datas.get(0);
                detailVO.setProjectName(plandName);
                try {
                    String minMny = (String)datas.get(1);
                    detailVO.setProposedInvestmentMny(StringUtils.isNotBlank((CharSequence)minMny) ? new BigDecimal(minMny) : null);
                }
                catch (Exception e) {
                    detailVO.setErrMsg("\u6700\u5c0f\u62df\u6295\u5165\u91d1\u989d\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String maxMny = (String)datas.get(2);
                    detailVO.setMaxProposedInvestmentMny(StringUtils.isNotBlank((CharSequence)maxMny) ? new BigDecimal(maxMny) : null);
                }
                catch (Exception e) {
                    detailVO.setErrMsg("\u6700\u5927\u62df\u6295\u5165\u91d1\u989d\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                String orgName = (String)datas.get(3);
                detailVO.setOrgName(orgName);
                try {
                    Integer orgType = Objects.equals(datas.get(4), "\u96c6\u56e2") ? Integer.valueOf(1) : (Objects.equals(datas.get(4), "\u5206\u516c\u53f8") ? Integer.valueOf(2) : Integer.valueOf(3));
                    detailVO.setOrgType(orgType);
                }
                catch (Exception e) {
                    detailVO.setErrMsg("\u7ec4\u7ec7\u7c7b\u578b\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                if (detailVO.getProposedInvestmentMny().compareTo(detailVO.getMaxProposedInvestmentMny()) > 0) {
                    detailVO.setErrMsg("\u6700\u5c0f\u62df\u6295\u5165\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u6700\u5927\u62df\u6295\u5165\u91d1\u989d!");
                    errorList.add(detailVO);
                }
                String memo = (String)datas.get(5);
                detailVO.setMemo(memo);
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

