package com.ejianc.business.jltest.margin.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.jltest.margin.vo.DirectEmployeeDetailVO;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 直管部缴纳员工表
 *
 * @author generator
 */
@TableName("ejc_jltest_direct_employee")
public class DirectEmployeeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "bill_code")
    private String billCode; // 单据编码
    @TableField(value = "standard_id")
    private Long standardId; // 标准表ID
    @TableField(value = "org_id")
    private Long orgId; // 申请组织
    @TableField(value = "org_name")
    private String orgName; // 组织名称
    @TableField(value = "org_code")
    private String orgCode; // 组织code
    @TableField(value = "year")
    private Integer year; // 所属年度
    @TableField(value = "direct_mny")
    private BigDecimal directMny; // 直管部缴纳金额
    @TableField(value = "standard_code")
    private String standardCode; // 标准表编码
    @TableField(value = "employee_mny")
    private BigDecimal employeeMny; // 员工应缴纳金额
    @TableField(value = "employee_actual_mny")
    private BigDecimal employeeActualMny; // 员工实际缴纳金额
    @TableField(value = "employee_id")
    private Long employeeId; // 经办人
    @TableField(value = "employee_name")
    private String employeeName; // 经办人名称
    @TableField(value = "department_id")
    private Long departmentId; // 经办部门
    @TableField(value = "department_name")
    private String departmentName; // 经办部门名称
    @TableField(value = "memo")
    private String memo; // 申请事由
    @TableField(value = "change_state")
    private Integer changeState; //变更状态 1-未变更 2-已变更 3-变更中
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态（审批必须字段）


    @TableField(exist = false)
    @SubEntity(serviceName = "directEmployeeDetailService", pidName = "directEmployeeId")
    private List<DirectEmployeeDetailEntity> detailList = new ArrayList<>();

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getStandardId() {
        return standardId;
    }

    public void setStandardId(Long standardId) {
        this.standardId = standardId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public BigDecimal getDirectMny() {
        return directMny;
    }

    public void setDirectMny(BigDecimal directMny) {
        this.directMny = directMny;
    }

    public String getStandardCode() {
        return standardCode;
    }

    public void setStandardCode(String standardCode) {
        this.standardCode = standardCode;
    }

    public BigDecimal getEmployeeMny() {
        return employeeMny;
    }

    public void setEmployeeMny(BigDecimal employeeMny) {
        this.employeeMny = employeeMny;
    }

    public BigDecimal getEmployeeActualMny() {
        return employeeActualMny;
    }

    public void setEmployeeActualMny(BigDecimal employeeActualMny) {
        this.employeeActualMny = employeeActualMny;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<DirectEmployeeDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<DirectEmployeeDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }
}
