package com.ejianc.business.jltest.margin.controller;

import java.io.Serializable;

import cn.hutool.Hutool;
import cn.hutool.core.lang.UUID;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jltest.margin.bean.*;
import com.ejianc.business.jltest.margin.service.*;
import com.ejianc.business.jltest.margin.vo.InspiritLossVO;
import com.ejianc.business.jltest.margin.vo.PaymentDetailsVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.units.qual.A;
import org.codehaus.groovy.runtime.powerassert.SourceText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.time.ZoneOffset;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jltest.margin.vo.EmployeeBillVO;

/**
 * 人员缴纳总台账
 *
 * @author generator
 */
@Controller
@RequestMapping("employeeBill")
public class EmployeeBillController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDirectEmployeeDetailService directEmployeeDetailService;

    @Autowired
    private IRiskPayConfirmationService riskPayConfirmationService;

    @Autowired
    private IMoneyRefundService moneyRefundService;

    @Autowired
    private IInspiritLossDetailService inspiritLossDetailService;

    @Autowired
    private IInspiritLossService inspiritLossService;


    private static final String BILL_CODE = "EmployeeBill";// 此处需要根据实际修改

    @Autowired
    private IEmployeeBillService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<EmployeeBillVO> saveOrUpdate(@RequestBody EmployeeBillVO saveOrUpdateVO) {
        EmployeeBillEntity entity = BeanMapper.map(saveOrUpdateVO, EmployeeBillEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                // entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                // entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        EmployeeBillVO vo = BeanMapper.map(entity, EmployeeBillVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EmployeeBillVO> queryDetail(Long id) {

        List<InspiritLossEntity> inspiritLossList = new ArrayList<>();
        QueryWrapper<InspiritLossEntity> inspiritLossEntityQueryWrapper = new QueryWrapper<>();
        inspiritLossEntityQueryWrapper.eq("employee_id",id);
        inspiritLossList = inspiritLossService.list(inspiritLossEntityQueryWrapper);
        // 人员姓名 联系方式
        QueryWrapper<DirectEmployeeDetailEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("employee_id", id);
        wrapper.select("distinct employee_name,phone");
        DirectEmployeeDetailEntity directEmployeeDetailEntity = directEmployeeDetailService.getOne(wrapper);
        // 累计缴纳金额
        BigDecimal paidMny = BigDecimal.ZERO;
        // 累计退还金额
        BigDecimal refundMny = BigDecimal.ZERO;
        // 实际缴纳金额
        BigDecimal actualPaidMny = BigDecimal.ZERO;
        // 已分配金额
        BigDecimal allotmentMny = BigDecimal.ZERO;

        EmployeeBillEntity employeeBillEntity = new EmployeeBillEntity();
        employeeBillEntity.setEmployeeName(directEmployeeDetailEntity.getEmployeeName());
        employeeBillEntity.setPhone(directEmployeeDetailEntity.getPhone());

        // 累计已缴纳金额
        QueryWrapper<RiskPayConfirmationEntity> rickPayConfirmationEntityQueryWrapper = new QueryWrapper<>();
        rickPayConfirmationEntityQueryWrapper.select("sum(current_payment_amount) as current_payment_amount").eq("employee_id", id).eq("isOk", 1);
        RiskPayConfirmationEntity riskPayConfirmationResult = riskPayConfirmationService.getOne(rickPayConfirmationEntityQueryWrapper);
        if (riskPayConfirmationResult != null) {
            paidMny = riskPayConfirmationResult.getCurrentPaymentAmount();
        }
        employeeBillEntity.setPaidMny(paidMny);
        // 累计退还金额
        QueryWrapper<MoneyRefundEntity> moneyRefundEntityQueryWrapper = new QueryWrapper<>();
        moneyRefundEntityQueryWrapper.select("sum(current_period_actual_due) as current_period_actual_due").eq("employee_id", id).eq("confirm_status", 3);
        MoneyRefundEntity moneyRefundResult = moneyRefundService.getOne(moneyRefundEntityQueryWrapper);
        if (moneyRefundResult != null) {
            refundMny = moneyRefundResult.getCurrentPeriodActualDue();
        }
        employeeBillEntity.setRefundMny(refundMny);
        // 实际缴纳金额
        actualPaidMny = paidMny.subtract(refundMny);
        employeeBillEntity.setActualPaidMny(actualPaidMny);
        // 已分配金额
        QueryWrapper<InspiritLossDetailEntity> inspiritLossQueryWrapper = new QueryWrapper<>();
        inspiritLossQueryWrapper.select("sum(detail_assessment) as detail_assessment").eq("detail_id", id);
        InspiritLossDetailEntity inspiritLossResult = inspiritLossDetailService.getOne(inspiritLossQueryWrapper);
        if (inspiritLossResult != null) {
            allotmentMny = inspiritLossResult.getDetailAssessment();
        }
        employeeBillEntity.setAllotmentMny(allotmentMny);
        //分配明细
        employeeBillEntity.setInspiritLossList(inspiritLossList);



        EmployeeBillVO vo = BeanMapper.map(employeeBillEntity, EmployeeBillVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EmployeeBillVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (EmployeeBillVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(EmployeeBillVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<EmployeeBillVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        // 当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {// 移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {// pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        // 普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        // 项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                // 项目部
                departmentIds.add(org.getId());
            } else {
                // 普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            // param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */


        // 台账列表
        List<EmployeeBillEntity> employeeBillList = new ArrayList<EmployeeBillEntity>();

        // distinct人员ID
        QueryWrapper<DirectEmployeeDetailEntity> wrapper = new QueryWrapper<>();
        Parameter orgId = param.getParams().get("orgId");
        if (orgId != null) {
            wrapper.eq("org_id", param.getParams().get("orgId").getValue());
        }
        wrapper.select("distinct employee_id,employee_name");
        // 人员集合
        List<DirectEmployeeDetailEntity> empList = directEmployeeDetailService.list(wrapper);

        IPage<EmployeeBillEntity> page = service.queryPage(param, false);

        // 遍历empList人员集合
        for (DirectEmployeeDetailEntity emp : empList) {
            // 累计缴纳金额
            BigDecimal paidMny = BigDecimal.ZERO;
            // 累计退还金额
            BigDecimal refundMny = BigDecimal.ZERO;
            // 实际缴纳金额
            BigDecimal actualPaidMny = BigDecimal.ZERO;
            // 已分配金额
            BigDecimal allotmentMny = BigDecimal.ZERO;
            EmployeeBillEntity employeeBillEntity = new EmployeeBillEntity();
            employeeBillEntity.setEmployeeName(emp.getEmployeeName());
            employeeBillEntity.setEmployeeId(emp.getEmployeeId());
            // 累计已缴纳金额
            QueryWrapper<RiskPayConfirmationEntity> rickPayConfirmationEntityQueryWrapper = new QueryWrapper<>();
            rickPayConfirmationEntityQueryWrapper.select("sum(current_payment_amount) as current_payment_amount").eq("employee_id", emp.getEmployeeId()).eq("isOk", 1);
            RiskPayConfirmationEntity riskPayConfirmationResult = riskPayConfirmationService.getOne(rickPayConfirmationEntityQueryWrapper);
            if (riskPayConfirmationResult != null) {
                paidMny = riskPayConfirmationResult.getCurrentPaymentAmount();
            }
            employeeBillEntity.setPaidMny(paidMny);
            // 累计退还金额
            QueryWrapper<MoneyRefundEntity> moneyRefundEntityQueryWrapper = new QueryWrapper<>();
            moneyRefundEntityQueryWrapper.select("sum(current_period_actual_due) as current_period_actual_due").eq("employee_id", emp.getEmployeeId()).eq("confirm_status", 3);
            MoneyRefundEntity moneyRefundResult = moneyRefundService.getOne(moneyRefundEntityQueryWrapper);
            if (moneyRefundResult != null) {
                refundMny = moneyRefundResult.getCurrentPeriodActualDue();
            }
            employeeBillEntity.setRefundMny(refundMny);
            // 实际缴纳金额
            actualPaidMny = paidMny.subtract(refundMny);
            employeeBillEntity.setActualPaidMny(actualPaidMny);
            // 已分配金额
            QueryWrapper<InspiritLossDetailEntity> inspiritLossQueryWrapper = new QueryWrapper<>();
            inspiritLossQueryWrapper.select("sum(detail_assessment) as detail_assessment").eq("detail_id", emp.getEmployeeId());
            InspiritLossDetailEntity inspiritLossResult = inspiritLossDetailService.getOne(inspiritLossQueryWrapper);
            if (inspiritLossResult != null) {
                allotmentMny = inspiritLossResult.getDetailAssessment();
            }
            employeeBillEntity.setAllotmentMny(allotmentMny);
            //
            System.out.println(employeeBillEntity.toString());
            page.getRecords().add(employeeBillEntity);
        }
        IPage<EmployeeBillVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), EmployeeBillVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        List<EmployeeBillEntity> list = new ArrayList<>();

        // distinct人员ID
        QueryWrapper<DirectEmployeeDetailEntity> wrapper = new QueryWrapper<>();
        Parameter orgId = param.getParams().get("orgId");
        if (orgId != null) {
            wrapper.eq("org_id", param.getParams().get("orgId").getValue());
        }
        wrapper.select("distinct employee_id,employee_name");
        // 人员集合
        List<DirectEmployeeDetailEntity> empList = directEmployeeDetailService.list(wrapper);

        IPage<EmployeeBillEntity> page = service.queryPage(param, false);

        // 遍历empList人员集合
        for (DirectEmployeeDetailEntity emp : empList) {
            // 累计缴纳金额
            BigDecimal paidMny = BigDecimal.ZERO;
            // 累计退还金额
            BigDecimal refundMny = BigDecimal.ZERO;
            // 实际缴纳金额
            BigDecimal actualPaidMny = BigDecimal.ZERO;
            // 已分配金额
            BigDecimal allotmentMny = BigDecimal.ZERO;
            EmployeeBillEntity employeeBillEntity = new EmployeeBillEntity();
            employeeBillEntity.setEmployeeName(emp.getEmployeeName());
            employeeBillEntity.setEmployeeId(emp.getEmployeeId());
            // 累计已缴纳金额
            QueryWrapper<RiskPayConfirmationEntity> rickPayConfirmationEntityQueryWrapper = new QueryWrapper<>();
            rickPayConfirmationEntityQueryWrapper.select("sum(current_payment_amount) as current_payment_amount").eq("employee_id", emp.getEmployeeId()).eq("isOk", 1);
            RiskPayConfirmationEntity riskPayConfirmationResult = riskPayConfirmationService.getOne(rickPayConfirmationEntityQueryWrapper);
            if (riskPayConfirmationResult != null) {
                paidMny = riskPayConfirmationResult.getCurrentPaymentAmount();
            }
            employeeBillEntity.setPaidMny(paidMny);
            // 累计退还金额
            QueryWrapper<MoneyRefundEntity> moneyRefundEntityQueryWrapper = new QueryWrapper<>();
            moneyRefundEntityQueryWrapper.select("sum(current_period_actual_due) as current_period_actual_due").eq("employee_id", emp.getEmployeeId()).eq("confirm_status", 3);
            MoneyRefundEntity moneyRefundResult = moneyRefundService.getOne(moneyRefundEntityQueryWrapper);
            if (moneyRefundResult != null) {
                refundMny = moneyRefundResult.getCurrentPeriodActualDue();
            }
            employeeBillEntity.setRefundMny(refundMny);
            // 实际缴纳金额
            actualPaidMny = paidMny.subtract(refundMny);
            employeeBillEntity.setActualPaidMny(actualPaidMny);
            // 已分配金额
            QueryWrapper<InspiritLossDetailEntity> inspiritLossQueryWrapper = new QueryWrapper<>();
            inspiritLossQueryWrapper.select("sum(detail_assessment) as detail_assessment").eq("detail_id", emp.getEmployeeId());
            InspiritLossDetailEntity inspiritLossResult = inspiritLossDetailService.getOne(inspiritLossQueryWrapper);
            if (inspiritLossResult != null) {
                allotmentMny = inspiritLossResult.getDetailAssessment();
            }
            employeeBillEntity.setAllotmentMny(allotmentMny);
            //
            System.out.println(employeeBillEntity.toString());
            list.add(employeeBillEntity);
        }


        // todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("EmployeeBill-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refEmployeeBillData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<EmployeeBillVO>> refEmployeeBillData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                     String condition,
                                                                     String searchObject,
                                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<EmployeeBillEntity> page = service.queryPage(param, false);
        IPage<EmployeeBillVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), EmployeeBillVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
